"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.genRouteFile = exports.genRoutesFile = exports.mgGenerateRoutes = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const init_magic_metadata_rule_1 = require("../magic-utils/rules/init-magic-metadata.rule");
const types_1 = require("../../types");
const generate_rule_1 = require("../magic-utils/rules/generate.rule");
const env_1 = require("../magic-utils/env");
const Util_1 = require("../magic-utils/Util");
function mgGenerateRoutes(options) {
    return (0, schematics_1.chain)([
        (0, init_magic_metadata_rule_1.initMagicMetadata)(options),
        genRoutesFile(options)
    ]);
}
exports.mgGenerateRoutes = mgGenerateRoutes;
//-------------------------------------------------------------------------------------------------
// generate all the modules in  env.modulesGen
//-------------------------------------------------------------------------------------------------
function genRoutesFile(options) {
    return (tree, context) => {
        const metadata = env_1.env.metadata;
        let routeTable = metadata.routesTable;
        let rules = [];
        context.logger.info(`routes length: ${routeTable.length}`);
        for (let routeItem of routeTable) {
            rules.push(genRouteFile(options, routeItem));
        }
        return (0, schematics_1.chain)(rules)(tree, context);
    };
}
exports.genRoutesFile = genRoutesFile;
function genRouteFile(options, routeItem) {
    return (host, context) => {
        const metadata = env_1.env.metadata;
        let createRootRoute = routeItem.module_name == '' ? true : false;
        (0, Util_1.LogLn)(`genRouteFile : [${routeItem.module_name}]  createRootRoute = ${createRootRoute}`);
        const data = {
            routesArray: routeItem.routesArray,
            createRootRoute: createRootRoute
        };
        let template = `./templates/angular/src/app.routes.ts`;
        let destinationPath = metadata.paths.rootMagicGenFolder;
        if (routeItem.module_name != '') {
            destinationPath = metadata.paths.magicGenFolderPath + `/${routeItem.module_name}`;
        }
        if (data.routesArray == undefined)
            context.logger.info(`RouteTable is not defined !`);
        else
            context.logger.info(`generating ${data.routesArray.length} root routes`);
        const componentFile = {
            type: types_1.GeneratedFileTypes.TS,
            template: template,
            destination: destinationPath,
            name: 'app.routes.ts',
            data: data
        };
        return (0, schematics_1.chain)([
            (0, generate_rule_1.generate)(componentFile, options)
        ])(host, context);
    };
}
exports.genRouteFile = genRouteFile;
//# sourceMappingURL=index.js.map