import { chain, forEach, Rule, SchematicContext, Tree, url } from "@angular-devkit/schematics";
import { initMagicMetadata } from "../magic-utils/rules/init-magic-metadata.rule";
import { GeneratedFileTypes, TemplateConfig } from "../../types";
import { generate } from "../magic-utils/rules/generate.rule";
import { env } from "../magic-utils/env";
import { MagicOptionScheme } from "../magic-utils/rules/magic-option.scheme";
import { RouteTable } from "../../types/interfaces/app";
import { LogLn } from "../magic-utils/Util";

export function mgGenerateRoutes(options: MagicOptionScheme): Rule {
  return chain([
    initMagicMetadata (options),
    genRoutesFile     (options)
  ]);
}

//-------------------------------------------------------------------------------------------------
// generate all the modules in  env.modulesGen
//-------------------------------------------------------------------------------------------------
export function genRoutesFile(options: MagicOptionScheme): Rule {
  return (tree: Tree, context: SchematicContext) => {

    const metadata  = env.metadata;
    let routeTable: RouteTable[] =  metadata.routesTable;
    let rules:Rule[] = [];

    context.logger.info(`routes length: ${routeTable.length}`);

    for (let routeItem of routeTable){
      rules.push(genRouteFile(options, routeItem));
    }

    return chain(rules)(tree,context);
  };
}





export function genRouteFile(options: MagicOptionScheme, routeItem : RouteTable ) : Rule {
  return (host: Tree, context: SchematicContext) => {
    const metadata  = env.metadata;
    let createRootRoute:boolean = routeItem.module_name =='' ? true: false;
    LogLn(`genRouteFile : [${routeItem.module_name}]  createRootRoute = ${createRootRoute}`)

    const data: any = {
      routesArray: routeItem.routesArray,
      createRootRoute:createRootRoute
    };

    let template : string = `./templates/angular/src/app.routes.ts`;
    let destinationPath:string  = metadata.paths.rootMagicGenFolder;
    if (routeItem.module_name != '')
    {
      destinationPath = metadata.paths.magicGenFolderPath + `/${routeItem.module_name}`;
    }

    if (data.routesArray  == undefined)
      context.logger.info(`RouteTable is not defined !`);
    else
      context.logger.info(`generating ${data.routesArray.length} root routes`);

    const componentFile: TemplateConfig = {
      type        : GeneratedFileTypes.TS,
      template    : template,                                   // `./templates/angular/src/app.routes.ts`,
      destination : destinationPath,                            // metadata.paths.rootMagicGenFolder,
      name        : 'app.routes.ts',
      data        : data
    };

    return chain([
      generate(componentFile,options)
    ])(host,context);
  }
}





