"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mgSingleControl = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const init_magic_metadata_rule_1 = require("../magic-utils/rules/init-magic-metadata.rule");
const init_gen_components_rule_1 = require("../magic-utils/rules/init-gen-components.rule");
const build_control_rule_1 = require("../magic-utils/rules/build-control.rule");
const env_1 = require("../magic-utils/env");
//
// entry point for generation of single control HTML
//
function mgSingleControl(options) {
    return (0, schematics_1.chain)([
        (0, init_magic_metadata_rule_1.initMagicMetadata)(options),
        initSingleControl(options),
        (0, init_gen_components_rule_1.initAndGenComponentsForModule)(options, false),
        (0, build_control_rule_1.buildControl)(options, "")
    ]);
}
exports.mgSingleControl = mgSingleControl;
//
// single control generation helper - turn on the no-log flag
//
function initSingleControl(options) {
    return (host, context) => {
        env_1.env.prevent_log = true;
        return host;
    };
}
//# sourceMappingURL=index.js.map