import { chain, Rule, SchematicContext, Tree, url } from "@angular-devkit/schematics";
import { initMagicMetadata} from "../magic-utils/rules/init-magic-metadata.rule";
import {
  initAndGenComponentsForModule
} from "../magic-utils/rules/init-gen-components.rule";
import { buildControl } from "../magic-utils/rules/build-control.rule";
import { env } from "../magic-utils/env";
import { MagicOptionScheme } from "../magic-utils/rules/magic-option.scheme";

//
// entry point for generation of single control HTML
//
export function mgSingleControl(options: MagicOptionScheme): Rule {
  return chain([
    initMagicMetadata(options),
    initSingleControl(options),
    initAndGenComponentsForModule (options, false),
    buildControl(options, "")
  ]);
}

//
// single control generation helper - turn on the no-log flag
//
function initSingleControl(options: MagicOptionScheme): Rule {
  return (host: Tree, context: SchematicContext) => {
    env.prevent_log = true;
    return host;
  };
}



