import {Control} from './control';
import { Data, LoadChildren, ResolveData, Routes, RunGuardsAndResolvers, UrlMatcher } from "@angular/router";
import { Type } from "@angular/core";

export interface View extends Control
{

}

export class Route{
    RouteName: string;
    OutletName: string;
    children: any[];
    ModuleName:string;
}

export class RouteTable{
  module_name:string;
  routesArray: Route[];
}

/*
* export interface Route {
    path?: string;
    pathMatch?: string;
    matcher?: UrlMatcher;
    component?: Type<any>;
    redirectTo?: string;
    outlet?: string;
    canActivate?: any[];
    canActivateChild?: any[];
    canDeactivate?: any[];
    canLoad?: any[];
    data?: Data;
    resolve?: ResolveData;
    children?: Routes;
    loadChildren?: LoadChildren;
    runGuardsAndResolvers?: RunGuardsAndResolvers;
}
* */

export interface AppJson {
    name  : string,
    suffix: string,
    views : View[]
}

export interface RouteJson
{
    routesArray: Route[]
}

export interface webModuleItem {
  module_name: string,
  load_on_demand: boolean;
  form_files: string[]
}

export interface AppConfig
{
    //created_application_css:	boolean,
    create_route_map: boolean
    create_new_project:	boolean,
    created_menu:	boolean,
    created_views:	boolean,
    theme:	string,
    output_folder:	string,
    backup_current:	boolean,
    source_images_folder: string,
    copy_images: boolean,
    exposed_functionality: boolean,
    allow_testing: boolean,
    project_name: string,
    web_modules: webModuleItem[],
    controls_accessor_only: boolean,
    no_controls_accessor: boolean
}

export interface ComponentId {
    jsonPath      : string;
    componentPath : string;
    name?         : string;
    uniqueName    : string;
    magicJsonObj? : View
}

export interface AppManifest{
    components: ComponentId[]
}
