import { MagicMetadata, MagicPaths } from "../../schematics/magic-utils/metadata.class";
import { AppJson } from "../index";
import { Project, Workspace } from "../../schematics/utils/devkit-utils/config";



export class ModuleInfo {
  moduleName: string;
  loadOnDemand: boolean;

  constructor(moduleName:string, loadOnDemand:boolean){
    this.moduleName = moduleName;
    this.loadOnDemand = loadOnDemand;
  }
}


export interface IEnv{
  workspace    : Workspace,
  project      : Project,
  metadata     : MagicMetadata;
  programList  : MagicMetadata;
  componentsGen: string[];
  modulesGen   : ModuleInfo[];
  app          : AppJson;
  paths?       : MagicPaths;
  prevent_log  : boolean;
}
