import {Routes, RouterModule} from '@angular/router';
import {RouterContainerMagicComponent} from  "@magic-xpa/angular";

import { CommonModule } from "@angular/common";
import { NgModule }  from '@angular/core';

 export const routes: Routes = [
    <%- startRanderForRootModule (createRootRoute); -%>
    <%- renderRoutes (routesArray, createRootRoute); -%>
    <%- endRanderForRootModule (createRootRoute); -%>
];

<% randerModule (createRootRoute); %>

<%#   some functions for help %>
<%#   ======================= %>

<%# Generate the routes using routesArray from json file %>
<% function renderRoutes (routesCollection, createRootRoute) { -%> <% routesCollection.forEach(route=>{ -%>
        {
          path : '<%=route.RouteName%>',
          <% if (route.ModuleName!= "") {-%>
               <% if (createRootRoute) { -%>
                    loadChildren:()=> import(`./magic/<%=route.ModuleName%>/magic.gen.lib.module`).then(m =>m.Magic<%=route.ModuleName%>Module),
               <%} else {-%>
                    loadChildren:()=> import(`../<%=route.ModuleName%>/magic.gen.lib.module`).then(m => m.Magic<%=route.ModuleName%>Module),
               <%}-%>
          <%} else {-%>
               component: RouterContainerMagicComponent,
          <%}-%>

        <% if (route.OutletName != "") { -%>
            outlet: '<%=route.OutletName%>',
            <%}-%>
            <%# Generate the children of routes %>
            <% if (route.children != null) {%>
            children: [
                <%- renderRoutes(route.children, createRootRoute)-%>
            ]
            <%}-%>
        },
        <%})-%>
    <%}-%>


<%# Generate the ngModule using from json file %>
<% function randerModule (createRootRoute) { %>
  @NgModule({
          imports: [CommonModule,
            <% if (createRootRoute == true) {%> RouterModule.forRoot(routes)], <%}else {%> RouterModule.forChild(routes)],<%}-%>
          exports: [RouterModule]
  })
  export class MagicRoutingModule { }

<%}%>

<%# start Generate the child  ?? ModuleEntryMagicComponent %>
<% function startRanderForRootModule (createRootRoute)
  { %>
  <% if (!createRootRoute) { -%>
    {
      path: '',
        component: RouterContainerMagicComponent,
        children: [
    <%}-%>
      <%}-%>

    <%# end Generate the child %>
    <% function endRanderForRootModule (createRootRoute) { %>
      <% if (!createRootRoute) {%>
      ]}
      <%}-%>
    <%}-%>
