<%
var
  useMatGrid  = false;
%>
<%= isUsingMatGrid(ctrl); %>


import { FormControl, FormGroup } from "@angular/forms";
import {
  MagicServices
} from "@magic-xpa/angular";

export enum MgControlName {
  <%- ctrl.props.id %> = "<%- ctrl.props.id -%>",
  <%= addEnumValues(ctrl); -%>
}

export enum MgCustomProperties {
  <%= addCustomPropertyEnumValues(ctrl); -%>
}

<% if(useMatGrid) { -%>
export var <%- include(`../themes/table/grid/additionalComponentCode`, {ctrl: ctrl}) -%>
<%}-%>

export  class MgFormControlsAccessor {

  constructor(private fg: FormGroup, private magicServices: MagicServices) {  }

  <%= addFormControlsAccessors(ctrl); %>

  getTableChildFormControl(name : MgControlName): FormControl
  {
    return this.magicServices.mgAccessorService.getFormGroupByRow(this.magicServices.tableService.getSelectedRow()).controls[name] as FormControl;
  }
}

<%# create the enum values for all control names. This method is recursive%>
<%_ function addEnumValues(parent) {                             -%>
<%_   if(parent.children) {                                      -%>
<% parent.children.forEach(child=> {                     -%>
<%_ if(child.controlType !== MgControlType.CTRL_TYPE_TABPAGE) { _%>
<%= child.props.id%> = "<%-child.props.id _%>",
<%_} -%>
<%_ addEnumValues(child); -%>
<%_         })                                                   -%>
<%_     }                                                        -%>
<%_ }                                                            -%>

<% function addCustomPropertyEnumValues(control) { -%>
<% if (control.props.custom_properties) { -%>
<% control.props.custom_properties.forEach(element => { -%>
<%- control.props.id %>_<%- element %> = '<%- control.props.id %>~<%- element %>' ,
<% })-%>
<% } -%>
<%_   if(control.children) {                                      -%>
<% control.children.forEach(child=> {                     -%>
<%- addCustomPropertyEnumValues(child) -%>
<% })-%>
<% } -%>
<% } -%>

<%# create the form control accessor for all relevant controls. This method is recursive%>
<% function addFormControlsAccessors(parent) {                  -%>
<%   if(parent.children) {                                      -%>
<%        parent.children.forEach(child=> {                     -%>
<%            switch (child.controlType){
              case MgControlType.CTRL_TYPE_TEXT:
              case MgControlType.CTRL_TYPE_CHECKBOX:
              case MgControlType.CTRL_TYPE_COMBO:
              case MgControlType.CTRL_TYPE_LIST:
              case MgControlType.CTRL_TYPE_RADIO:              %>
<%            if(child.props.is_table_child) {                  -%>
                get <%-child.props.id%>(): FormControl {
                  return this.getTableChildFormControl(MgControlName.<%-child.props.id%>);
                }
<%            } else {                                          -%>
                get <%-child.props.id%>(): FormControl {
                  return this.fg.controls[MgControlName.<%-child.props.id%>] as FormControl;
                }
<%            }                                                 -%>
<%  break}                                                    -%>
<%-            addFormControlsAccessors(child);                -%>
<%         })                                                  -%>
<%     }                                                       -%>
<% }                                                           -%>

<%# A function used to decide if we need to use the material theme code or the basic HTML code.
  material code is needed if we are in material design theme or if we have a table with the MatGrid style %>
<% function isUsingMatGrid(parent) {                             %>
<%   if(parent.children){                                                          %>
<%       parent.children.forEach(child=> {                                         %>
<%           if(child.controlType === MgControlType.CTRL_TYPE_TABLE) {             %>
<%               if(typeof child.props.web_style === "undefined" ||
          child.props.web_style === TableWebStyle.MatGrid) {            %>
<%                    useMatGrid = true;                                          %>
<%                    return;                                                      %>
<%               }                                                                 %>
<%           }                                                                     %>
<%       })                                                                        %>

<%        parent.children.forEach(child=> {                                        %>
<%            isUsingMatGrid(child);                                    %>
<%            if(useMatGrid);                                                     %>
<%                 return;                                                         %>
<%         })                                                                      %>
<%     }                                                                           %>
<% }                                                                               %>
