<%
var
   id = ctrl.props.id,
   selector = app.suffix + '-' + id,
   useMatGrid  = false;
   isModal = (ctrl.props.window_type && ctrl.props.window_type == WindowType.Overlay);
%>
<%= isUsingMatGrid(ctrl, theme); %>

import {Component} from '@angular/core';
<% if(!magicConfig.no_controls_accessor) { %>
import {  FormGroup } from "@angular/forms";

import { MgFormControlsAccessor, MgControlName, MgCustomProperties} from "./<%- id %>.mg.controls.g";
<% if(useMatGrid) { -%>
import { MgDisplayedColumns} from "./<%- id %>.mg.controls.g";
<%}-%>
<%}%>

<% if(useMatGrid) { %>
    <%- include(`../themes/table/grid/additionalIncludes`) %>
 <% } else {%>
  import {TaskBaseMagicComponent, magicProviders} from  "@magic-xpa/angular";
<%}%>
<% if(isModal) { %>
  import {MagicModalInterface} from  "@magic-xpa/angular";
<%}%>

@Component({
    selector: '<%= selector %>',
    providers: [... <% if(useMatGrid) { %>  matMagicProviders <% } else {%> magicProviders     <%}%> ],
    templateUrl: './<%- id %>.component.html'
})

export class <%- id %> extends <% if(useMatGrid) { %>  BaseMatTableMagicComponent <% } else {%> TaskBaseMagicComponent     <%}%> <% if(isModal) { %> implements MagicModalInterface <% }%>

{
  <% if(!magicConfig.no_controls_accessor) { %>
  mgc = MgControlName;
  mgcp = MgCustomProperties;
  mgfc!: MgFormControlsAccessor;

  <% if(useMatGrid) { -%>
  mgdp= MgDisplayedColumns;
  <%}-%>


  override createFormControlsAccessor(formGroup: FormGroup)
  {
    this.mgfc = new MgFormControlsAccessor(formGroup, this.magicServices);
  }
  <%}-%>

  <% if(isModal) { -%>
    private static readonly formName: string = "<%- id %>";
    private static readonly showTitleBar: boolean = true;
    private static readonly x: number = 0;
    private static readonly y: number = 0;
    private static readonly width: string = "300px";
    private static readonly height: string = "300px";
    private static readonly isCenteredToWindow: boolean = true;
    private static readonly shouldCloseOnBackgroundClick = true;

    X() {
        return <%- id %>.x;
    }

    Y() {
        return <%- id %>.y;
    }

    Width(): string {
        return <%- id %>.width;
    }

    Height(): string {
        return <%- id %>.height;
    }

    IsCenteredToWindow() {
        return <%- id %>.isCenteredToWindow;
    }

    FormName() {
        return <%- id %>.formName;
    }

    ShowTitleBar() {
        return <%- id %>.showTitleBar;
    }

    ShouldCloseOnBackgroundClick() {
      return <%- id %>.shouldCloseOnBackgroundClick;
    }
    <%}-%>
    <% if(useMatGrid) { -%>
    override displayedColumns = this.mgdp;
    <%}-%>
}


<%# A function used to decide if we need to use the material theme code or the basic HTML code.
material code is needed if we are in material design theme or if we have a table with the MatGrid style %>
<% function isUsingMatGrid(parent, theme) {                             %>
<%   if(parent.children){                                                          %>
<%       parent.children.forEach(child=> {                                         %>
<%           if(child.controlType === MgControlType.CTRL_TYPE_TABLE) {             %>
<%               if(typeof child.props.web_style === "undefined" ||
                     child.props.web_style === TableWebStyle.MatGrid) {            %>
<%                    useMatGrid = true;                                          %>
<%                    return;                                                      %>
<%               }                                                                 %>
<%           }                                                                     %>
<%       })                                                                        %>

<%        parent.children.forEach(child=> {                                        %>
<%            isUsingMatGrid(child);                                    %>
<%            if(useMatGrid);                                                     %>
<%                 return;                                                         %>
<%         })                                                                      %>
<%     }                                                                           %>
<% }                                                                               %>
