import { XMLConstants } from '@magic-xpa/utils';
import { Scrambler } from './util/Scrambler';
import { isNullOrUndefined } from '@magic-xpa/mscorelib';
export var CommandsProcessorBase_SessionStage;
(function (CommandsProcessorBase_SessionStage) {
    CommandsProcessorBase_SessionStage[CommandsProcessorBase_SessionStage["HANDSHAKE"] = 1] = "HANDSHAKE";
    CommandsProcessorBase_SessionStage[CommandsProcessorBase_SessionStage["INITIAL"] = 2] = "INITIAL";
    CommandsProcessorBase_SessionStage[CommandsProcessorBase_SessionStage["NORMAL"] = 3] = "NORMAL";
})(CommandsProcessorBase_SessionStage || (CommandsProcessorBase_SessionStage = {}));
export var CommandsProcessorBase_SendingInstruction;
(function (CommandsProcessorBase_SendingInstruction) {
    CommandsProcessorBase_SendingInstruction[CommandsProcessorBase_SendingInstruction["NO_TASKS_OR_COMMANDS"] = 0] = "NO_TASKS_OR_COMMANDS";
    CommandsProcessorBase_SendingInstruction[CommandsProcessorBase_SendingInstruction["ONLY_COMMANDS"] = 1] = "ONLY_COMMANDS";
    CommandsProcessorBase_SendingInstruction[CommandsProcessorBase_SendingInstruction["TASKS_AND_COMMANDS"] = 2] = "TASKS_AND_COMMANDS";
})(CommandsProcessorBase_SendingInstruction || (CommandsProcessorBase_SendingInstruction = {}));
export class CommandsProcessorBase {
    constructor() {
        this._sessionCounter = 0;
    }
    GetSessionCounter() {
        return this._sessionCounter;
    }
    async StartSession() {
        return Promise.resolve(true);
    }
    async Execute(sendingInstruction, sessionStage, res) {
        if (isNullOrUndefined(sessionStage)) {
            await this.Execute_0(sendingInstruction);
            return;
        }
        await this.Execute_1(sendingInstruction, sessionStage, res);
    }
    async Execute_0(sendingInstruction) {
        await this.Execute_1(sendingInstruction, CommandsProcessorBase_SessionStage.NORMAL, null);
    }
    async Execute_1(sendingInstruction, sessionStage, res) {
        return Promise.resolve();
    }
    async GetContent(requestedURL, useCache) {
        return Promise.resolve('');
    }
    static UnScramble(respBuf) {
        let openTagLocation = respBuf.indexOf(XMLConstants.MG_TAG_OPEN);
        let core;
        if (openTagLocation !== -1) {
            let start = openTagLocation + XMLConstants.MG_TAG_OPEN.length;
            let openTag = respBuf.substr(0, start);
            let finish = respBuf.lastIndexOf(XMLConstants.TAG_OPEN);
            let closeTag = respBuf.substr(finish);
            core = openTag + Scrambler.UnScramble(respBuf, start, finish - 1) + closeTag;
        }
        else {
            core = Scrambler.UnScramble(respBuf, 0, respBuf.length - 1);
        }
        return core;
    }
}
//# sourceMappingURL=data:application/json;base64,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