import { Logger, StrUtil } from "@magic-xpa/utils";
import { RemoteCommandsProcessor } from "./remote/RemoteCommandsProcessor";
import { HttpManager } from "./http/HttpManager";
import { InteractiveCommunicationsFailureHandler } from "./communications/InteractiveCommunicationsFailureHandler";
export class CommandsProcessorManager {
    static GetCommandsProcessor() {
        return RemoteCommandsProcessor.GetInstance();
    }
    static async GetContent(requestedURL, useCache) {
        let ret = await (CommandsProcessorManager.GetCommandsProcessor().GetContent(requestedURL, useCache));
        return ret;
    }
    static async StartSession() {
        let succeeded = false;
        try {
            HttpManager.GetInstance().SetCommunicationsFailureHandler(new InteractiveCommunicationsFailureHandler());
            succeeded = await RemoteCommandsProcessor.GetInstance().StartSession();
        }
        catch (ex) {
            Logger.Instance.WriteServerToLog("Failed connecting to the server: " + StrUtil.getConsoleErorString(ex.Message));
            throw ex;
        }
        return succeeded;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ29tbWFuZHNQcm9jZXNzb3JNYW5hZ2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy9Db21tYW5kc1Byb2Nlc3Nvck1hbmFnZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsTUFBTSxrQkFBa0IsQ0FBQztBQUVuRCxPQUFPLEVBQUMsdUJBQXVCLEVBQUMsTUFBTSxrQ0FBa0MsQ0FBQztBQUN6RSxPQUFPLEVBQUMsV0FBVyxFQUFDLE1BQU0sb0JBQW9CLENBQUM7QUFDL0MsT0FBTyxFQUFDLHVDQUF1QyxFQUFDLE1BQU0sMERBQTBELENBQUM7QUFHakgsTUFBTSxPQUFPLHdCQUF3QjtJQUtuQyxNQUFNLENBQUMsb0JBQW9CO1FBQ3pCLE9BQU8sdUJBQXVCLENBQUMsV0FBVyxFQUFFLENBQUM7SUFDL0MsQ0FBQztJQU9ELE1BQU0sQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLFlBQW9CLEVBQUUsUUFBaUI7UUFDN0QsSUFBSSxHQUFHLEdBQVcsTUFBTSxDQUFDLHdCQUF3QixDQUFDLG9CQUFvQixFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFDO1FBQzdHLE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQztJQU1BLE1BQU0sQ0FBQyxLQUFLLENBQUMsWUFBWTtRQUN4QixJQUFJLFNBQVMsR0FBWSxLQUFLLENBQUM7UUFDL0IsSUFBSTtZQUNGLFdBQVcsQ0FBQyxXQUFXLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxJQUFJLHVDQUF1QyxFQUFFLENBQUMsQ0FBQztZQUd6RyxTQUFTLEdBQUcsTUFBTSx1QkFBdUIsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxZQUFZLEVBQUUsQ0FBQztTQUN4RTtRQUNELE9BQU8sRUFBRSxFQUFFO1lBQ1QsTUFBTSxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxtQ0FBbUMsR0FBRyxPQUFPLENBQUMsb0JBQW9CLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDakgsTUFBTSxFQUFFLENBQUM7U0FDVjtRQUVELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IExvZ2dlciwgU3RyVXRpbCB9IGZyb20gXCJAbWFnaWMteHBhL3V0aWxzXCI7XHJcbmltcG9ydCB7Q29tbWFuZHNQcm9jZXNzb3JCYXNlfSBmcm9tIFwiLi9Db21tYW5kc1Byb2Nlc3NvckJhc2VcIjtcclxuaW1wb3J0IHtSZW1vdGVDb21tYW5kc1Byb2Nlc3Nvcn0gZnJvbSBcIi4vcmVtb3RlL1JlbW90ZUNvbW1hbmRzUHJvY2Vzc29yXCI7XHJcbmltcG9ydCB7SHR0cE1hbmFnZXJ9IGZyb20gXCIuL2h0dHAvSHR0cE1hbmFnZXJcIjtcclxuaW1wb3J0IHtJbnRlcmFjdGl2ZUNvbW11bmljYXRpb25zRmFpbHVyZUhhbmRsZXJ9IGZyb20gXCIuL2NvbW11bmljYXRpb25zL0ludGVyYWN0aXZlQ29tbXVuaWNhdGlvbnNGYWlsdXJlSGFuZGxlclwiO1xyXG5cclxuLy8gVE9ETzogQ29uc2lkZXIgcmVtb3ZpbmcgdGhpcyBjbGFzcyBhbmQgdXNpbmcgUmVtb3RlQ29tbWFuZHNQcm9jZXNzb3IgZGlyZWN0bHkuXHJcbmV4cG9ydCBjbGFzcyBDb21tYW5kc1Byb2Nlc3Nvck1hbmFnZXIge1xyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gZ2V0IHRoZSBjb21tYW5kcyBwcm9jZXNzb3JcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cmV0dXJucz48L3JldHVybnM+XHJcbiAgc3RhdGljIEdldENvbW1hbmRzUHJvY2Vzc29yKCk6IENvbW1hbmRzUHJvY2Vzc29yQmFzZSB7XHJcbiAgICByZXR1cm4gUmVtb3RlQ29tbWFuZHNQcm9jZXNzb3IuR2V0SW5zdGFuY2UoKTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gZ2V0IHRoZSBVUkwgY29udGVudCBhY2NvcmRpbmcgdG8gdGhlIGFjdGl2ZSBjb21tYW5kcyBwcm9jZXNzb3JcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZT1cInJlcXVlc3RlZFVSTFwiPjwvcGFyYW0+XHJcbiAgLy8vIDxyZXR1cm5zPjwvcmV0dXJucz5cclxuICBzdGF0aWMgYXN5bmMgR2V0Q29udGVudChyZXF1ZXN0ZWRVUkw6IHN0cmluZywgdXNlQ2FjaGU6IGJvb2xlYW4pOiBQcm9taXNlPHN0cmluZz4ge1xyXG4gICAgbGV0IHJldDogc3RyaW5nID0gYXdhaXQgKENvbW1hbmRzUHJvY2Vzc29yTWFuYWdlci5HZXRDb21tYW5kc1Byb2Nlc3NvcigpLkdldENvbnRlbnQocmVxdWVzdGVkVVJMLCB1c2VDYWNoZSkpO1xyXG4gICAgcmV0dXJuIHJldDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gU3RhcnQgc2Vzc2lvblxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxyZXR1cm5zPjwvcmV0dXJucz5cclxuICAgc3RhdGljIGFzeW5jIFN0YXJ0U2Vzc2lvbigpOiBQcm9taXNlPGJvb2xlYW4+IHtcclxuICAgIGxldCBzdWNjZWVkZWQ6IGJvb2xlYW4gPSBmYWxzZTtcclxuICAgIHRyeSB7XHJcbiAgICAgIEh0dHBNYW5hZ2VyLkdldEluc3RhbmNlKCkuU2V0Q29tbXVuaWNhdGlvbnNGYWlsdXJlSGFuZGxlcihuZXcgSW50ZXJhY3RpdmVDb21tdW5pY2F0aW9uc0ZhaWx1cmVIYW5kbGVyKCkpO1xyXG5cclxuICAgICAgLy8gYWNjZXNzIHRoZSBTZXJ2ZXJcclxuICAgICAgc3VjY2VlZGVkID0gYXdhaXQgUmVtb3RlQ29tbWFuZHNQcm9jZXNzb3IuR2V0SW5zdGFuY2UoKS5TdGFydFNlc3Npb24oKTtcclxuICAgIH1cclxuICAgIGNhdGNoIChleCkge1xyXG4gICAgICBMb2dnZXIuSW5zdGFuY2UuV3JpdGVTZXJ2ZXJUb0xvZyhcIkZhaWxlZCBjb25uZWN0aW5nIHRvIHRoZSBzZXJ2ZXI6IFwiICsgU3RyVXRpbC5nZXRDb25zb2xlRXJvclN0cmluZyhleC5NZXNzYWdlKSk7XHJcbiAgICAgIHRocm93IGV4O1xyXG4gICAgfVxyXG5cclxuICAgIHJldHVybiBzdWNjZWVkZWQ7XHJcbiAgfVxyXG59XHJcbiJdfQ==