import { MsgInterface } from '@magic-xpa/utils';
import { Commands, Manager, Styles } from '@magic-xpa/gui';
import { RCTimer } from './tasks/RCTimer';
import { LanguageData } from './env/LanguageData';
import { AccessHelper } from './AccessHelper';
export class GUIManager {
    static get Instance() {
        if (GUIManager._instance === null)
            GUIManager._instance = new GUIManager();
        return GUIManager._instance;
    }
    execGuiCommandQueue() {
        Commands.beginInvoke();
    }
    startTimer(mgData, seconds, isIdleTimer) {
        if (seconds > 0) {
            let objRCTimer = new RCTimer(mgData, seconds * 1000, isIdleTimer);
            (objRCTimer).Start();
            Commands.beginInvoke();
        }
    }
    stopTimer(mgData, seconds, isIdleTimer) {
        if (seconds > 0)
            RCTimer.StopTimer(mgData, seconds * 1000, isIdleTimer);
    }
    abort(form) {
        if (arguments.length === 1)
            this.abort_0(form);
        else
            this.abort_1();
    }
    abort_0(form) {
        if (form !== null) {
            Manager.Abort(form);
        }
    }
    abort_1() {
        for (let i = AccessHelper.mgDataTable.getSize(); i > 0; i--) {
            const task = AccessHelper.mgDataTable.getMGData(i - 1).getFirstTask();
            if (task !== null)
                this.abort(task.Form);
        }
    }
    async MessageBox(title, msg, style) {
        await AccessHelper.eventsManager.CheckAndShowSpinner(false);
        return await Commands.messageBox(title, msg, style);
    }
    async writeToMessageBox(titleId, msgId, style) {
        let title = LanguageData.Instance.getConstMessage(titleId);
        let msg = LanguageData.Instance.getConstMessage(msgId);
        return await this.MessageBox(title, msg, style);
    }
    async confirm(msgId, style) {
        return await this.writeToMessageBox(MsgInterface.CONFIRM_STR_WINDOW_TITLE, msgId, style);
    }
    async confirm_bool(msgId) {
        let retResult = await this.confirm(msgId, Styles.MSGBOX_BUTTON_OK_CANCEL);
        return retResult == Styles.MSGBOX_RESULT_OK;
    }
}
GUIManager._instance = null;
//# sourceMappingURL=data:application/json;base64,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