import { NString } from '@magic-xpa/mscorelib';
import { GuiConstants } from '@magic-xpa/gui';
import { ConstInterface } from './ConstInterface';
import { HttpManager } from './http/HttpManager';
export class ServerConfig {
    constructor() {
        this._protocol = null;
        this._server = null;
        this._httpReq = null;
        this._appName = null;
        this._serverUrl = null;
    }
    Init(obj) {
        this._executionProps = obj;
    }
    ShouldDisplayGenericError() {
        return this._executionProps.DisplayGenericError;
    }
    setUsername(username) {
        this._executionProps[ConstInterface.MG_TAG_USERNAME] = username;
    }
    setPassword(password) {
        this._executionProps[ConstInterface.MG_TAG_PASSWORD] = password;
    }
    setSkipAuthenticationDialog(value) {
        this._executionProps[ConstInterface.REQ_SKIP_AUTHENTICATION] = value.toString();
    }
    setGlobalParams(val) {
        if (val !== null)
            this._executionProps[ConstInterface.MG_TAG_GLOBALPARAMS] = val;
        else
            delete this._executionProps[ConstInterface.MG_TAG_GLOBALPARAMS];
    }
    getGlobalParams() {
        let ret = this._executionProps[ConstInterface.MG_TAG_GLOBALPARAMS];
        return typeof ret === "undefined" ? null : ret;
    }
    getProtocol() {
        if (this._protocol === null)
            this._protocol = this._executionProps.protocol;
        return this._protocol;
    }
    getServer() {
        if (this._server === null)
            this._server = this._executionProps.server;
        return this._server;
    }
    getHttpReq() {
        if (this._httpReq === null) {
            this._httpReq = this._executionProps.requester;
            if (this._httpReq !== null) {
                while (this._httpReq.startsWith("/"))
                    this._httpReq = this._httpReq.substr(1);
                while (this._httpReq.endsWith("/"))
                    this._httpReq = this._httpReq.substr(0, this._httpReq.length - 1);
            }
        }
        return this._httpReq;
    }
    getAppName() {
        if (this._appName === null)
            this._appName = this._executionProps.appname;
        return this._appName;
    }
    getInternalLogLevel() {
        return this._executionProps.InternalLogLevel;
    }
    setInternalLogLevel(value) {
        this._executionProps.InternalLogLevel = value;
    }
    getInternalLogSync() {
        return this._executionProps.InternalLogSync;
    }
    getUsername() {
        let ret = this._executionProps[ConstInterface.MG_TAG_USERNAME];
        return typeof ret === "undefined" ? null : ret;
    }
    getPassword() {
        let ret = this._executionProps[ConstInterface.MG_TAG_PASSWORD];
        return typeof ret === "undefined" ? null : ret;
    }
    getCtxGroup() {
        let ret = this._executionProps[ConstInterface.CTX_GROUP];
        return typeof ret === "undefined" ? null : ret;
    }
    setCtxGroup(CtxGroup) {
        this._executionProps[ConstInterface.CTX_GROUP] = CtxGroup;
    }
    getSkipAuthenticationDialog() {
        let property = this._executionProps[ConstInterface.REQ_SKIP_AUTHENTICATION];
        return !NString.IsNullOrEmpty(property) && property === true.toString();
    }
    GetFirstHttpRequestTimeout() {
        let firstHttpTimeout = this._executionProps.FirstHTTPRequestTimeout;
        return ((firstHttpTimeout > 0) ? (firstHttpTimeout * 1000) : HttpManager.DEFAULT_OFFLINE_HTTP_COMMUNICATION_TIMEOUT);
    }
    GetExecutionProperty(propName) {
        let ret = this._executionProps[propName];
        return typeof ret === "undefined" ? null : ret;
    }
    getServerURL() {
        if (this._serverUrl === null) {
            let httpReq = ServerConfig.Instance.getHttpReq();
            if (httpReq !== null && httpReq.toLowerCase().startsWith("http"))
                this._serverUrl = httpReq;
            else
                this._serverUrl = ServerConfig.Instance.getProtocol() + "://" + ServerConfig.Instance.getServer() + "/" + ServerConfig.Instance.getHttpReq();
        }
        return this._serverUrl;
    }
    IsLogonRTL() {
        let text = ServerConfig.Instance.GetExecutionProperty[GuiConstants.STR_LOGON_RTL];
        return text !== null && typeof text !== "undefined" && text === "Y";
    }
}
ServerConfig.Instance = new ServerConfig();
//# sourceMappingURL=data:application/json;base64,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