import { UIBridge } from "@magic-xpa/gui";
import { ClientManager } from "../ClientManager";
export class MagicBridge {
    static Initialize(httpClient) {
        ClientManager.Main(httpClient);
    }
    static async TerminateMagic() {
        await ClientManager.StopExecution();
    }
    static registerExecuteCommandsCallback(cb) {
        UIBridge.getInstance().registerExecuteCommandsCallback(cb);
    }
    static registerInteractiveCallback(cb) {
        UIBridge.getInstance().registerInteractiveCallback(cb);
    }
    static insertEvent(guiEvent) {
        ClientManager.Instance.AddEvent(guiEvent);
    }
    static GetControlPictureMask(taskId, controlName) {
        return ClientManager.GetControlPictureMask(taskId, controlName);
    }
    static GetFormattedValue(taskId, controlName, value, rowId) {
        return ClientManager.GetFormattedValue(taskId, controlName, value, rowId);
    }
    static GetRangedValue(taskId, controlName, value) {
        return ClientManager.GetRangedValue(taskId, controlName, value);
    }
    static ValidateControlValue(taskId, controlName, value) {
        return ClientManager.ValidateControlValue(taskId, controlName, value);
    }
    static GetFldRanges(taskId, controlName) {
        return ClientManager.GetFldRanges(taskId, controlName);
    }
    static TransCacheExists() {
        return ClientManager.TransCacheExists();
    }
    static TerminateContextUsingFetchAPI() {
        ClientManager.TerminateContextUsingFetchAPI();
    }
}
//# sourceMappingURL=data:application/json;base64,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