import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { InternalInterface } from '@magic-xpa/utils';
import { ConstInterface } from '../../ConstInterface';
import { NString, isNullOrUndefined } from '@magic-xpa/mscorelib';
export class BrowserEscEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_BROWSER_ESC);
        this.CloseSubformOnly = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, "1");
        helper.SerializeCloseSubformOnly(this.CloseSubformOnly);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0}{1} in {2}]', this.EventDescription, this.CloseSubformOnly ? ' Subform Only' : NString.Empty, isNullOrUndefined(this.Task) ? NString.Empty : this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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