import { Logger, XMLConstants } from "@magic-xpa/utils";
import { Exception, RefParam, StringBuilder } from "@magic-xpa/mscorelib";
import { ConstInterface } from "../../ConstInterface";
import { LastFocusedManager } from "../../rt/LastFocusedManager";
export class ClientOriginatedCommandSerializer {
    static Serialize(cmd, currMGData) {
        if (!cmd.ShouldSerialize)
            return null;
        let message = new StringBuilder();
        let hasChildElements = false;
        message.Append(XMLConstants.START_TAG + ConstInterface.MG_TAG_COMMAND);
        message.Append(" " + XMLConstants.MG_ATTR_TYPE + "=\"" + cmd.CommandTypeAttribute + "\"");
        let refHasChildElements = new RefParam(hasChildElements);
        message.Append(cmd.SerializeCommandData());
        hasChildElements = refHasChildElements.value;
        if (cmd.ShouldSerializeRecords)
            message.Append(ClientOriginatedCommandSerializer.SerializeRecords(currMGData));
        if (hasChildElements)
            message.Append(XMLConstants.TAG_CLOSE);
        else
            message.Append(XMLConstants.TAG_TERM);
        message.Append(cmd.SerializeDataAfterCommand());
        return message.ToString();
    }
    static SerializeRecords(currMGData) {
        let message = new StringBuilder();
        try {
            let length = currMGData.getTasksCount();
            let titleExist = false;
            let currFocusedTask = LastFocusedManager.Instance.getLastFocusedTask();
            for (let i = 0; i < length; i++) {
                let task = currMGData.getTask(i);
                let ctrl = task.getLastParkedCtrl();
                if (ctrl !== null) {
                    if (!titleExist) {
                        message.Append(" " + ConstInterface.MG_ATTR_FOCUSLIST + "=\"");
                        titleExist = true;
                    }
                    else
                        message.Append('$');
                    message.Append(task.getTaskTag() + ",");
                    message.Append(task.getLastParkedCtrl().getDitIdx());
                }
            }
            if (titleExist)
                message.Append("\"");
            if (currFocusedTask !== null)
                message.Append(" " + ConstInterface.MG_ATTR_FOCUSTASK + "=\"" + currFocusedTask.getTaskTag() + "\"");
        }
        catch (ex) {
            if (ex instanceof Exception) {
                Logger.Instance.WriteExceptionToLog(ex);
            }
            else
                throw ex;
        }
        return message.ToString();
    }
}
//# sourceMappingURL=data:application/json;base64,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