import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { NString } from '@magic-xpa/mscorelib';
import { InternalInterface } from '@magic-xpa/utils';
import { ConstInterface } from '../../ConstInterface';
export class ColumnSortEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_COL_SORT);
        this.FldId = 0;
        this.DitIdx = 0;
        this.Direction = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeFldId(this.FldId);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeDitIdx(this.DitIdx);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_DIRECTION, this.Direction);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for column {1} in {2}]', this.EventDescription, this.Task.getForm().getCtrl(this.DitIdx).getName(), this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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