import { NUM_TYPE } from '@magic-xpa/gui';
import { InternalInterface, StorageAttribute, ViewRefreshMode } from '@magic-xpa/utils';
import { EventCommand } from './EventCommand';
import { RollbackEventCommand } from './RollbackEventCommand';
import { DataviewCommand, DataViewCommandType } from './DataviewCommand';
import { AddUserRangeDataviewCommand } from './AddUserRangeDataviewCommand';
import { AddUserSortDataViewCommand } from './AddUserSortDataViewCommand';
import { AddUserLocateDataViewCommand } from './AddUserLocateDataViewCommand';
import { SetTransactionStateDataviewCommand } from './SetTransactionStateDataviewCommand';
import { RefreshEventCommand } from './RefreshEventCommand';
import { FetchDataControlValuesEventCommand } from './FetchDataControlValuesEventCommand';
import { SubformRefreshEventCommand } from './SubformRefreshEventCommand';
import { BrowserEscEventCommand } from './BrowserEscEventCommand';
import { IndexChangeEventCommand } from './IndexChangeEventCommand';
import { ColumnSortEventCommand } from './ColumnSortEventCommand';
import { RefreshScreenEventCommand } from './RefreshScreenEventCommand';
import { SubformOpenEventCommand } from './SubformOpenEventCommand';
import { ComputeEventCommand } from './ComputeEventCommand';
import { NonReversibleExitEventCommand } from './NonReversibleExitEventCommand';
import { RecomputeCommand } from './RecomputeCommand';
import { TransactionCommand } from './TransactionCommand';
import { UnloadCommand } from './UnloadCommand';
import { ExecOperCommand } from './ExecOperCommand';
import { EvaluateCommand } from './EvaluateCommand';
import { GlobalParamsQueryCommand } from './GlobalParamsQueryCommand';
import { IniputForceWriteCommand } from './IniputForceWriteCommand';
import { ContextTerminationEventCommand } from './ContextTerminationEventCommand';
import { ContextTimeoutResetCommand } from './ContextTimeoutResetCommand';
import { SelectProgramCommand } from './SelectProgramCommand';
import { ControlItemsRefreshCommand } from './ControlItemsRefreshCommand';
export class CommandFactory {
    static CreateEventCommand(taskTag, magicEvent) {
        let eventCommand = new EventCommand(magicEvent);
        eventCommand.TaskTag = taskTag;
        return eventCommand;
    }
    static CreateRollbackEventCommand(taskTag, rollbackType) {
        let cmd = new RollbackEventCommand();
        cmd.TaskTag = taskTag;
        cmd.Rollback = rollbackType;
        return cmd;
    }
    static CreateDataViewCommand(taskId, commandType) {
        let dataviewCommand = new DataviewCommand();
        dataviewCommand.CommandType = commandType;
        dataviewCommand.TaskTag = taskId;
        return dataviewCommand;
    }
    static CreateControlItemsRefreshCommand(taskId, control) {
        let command = new ControlItemsRefreshCommand();
        command.CommandType = DataViewCommandType.ControlItemsRefresh;
        command.TaskTag = taskId;
        command.Control = control;
        return command;
    }
    static CreateAddUserRangeDataviewCommand(taskId, userRange) {
        let addUserRangeDataviewCommand = new AddUserRangeDataviewCommand();
        addUserRangeDataviewCommand.TaskTag = taskId;
        addUserRangeDataviewCommand.Range = userRange;
        return addUserRangeDataviewCommand;
    }
    static CreateAddUserSortDataviewCommand(taskId, sort) {
        let addUserSortDataViewCommand = new AddUserSortDataViewCommand();
        addUserSortDataViewCommand.TaskTag = taskId;
        addUserSortDataViewCommand.Sort = sort;
        return addUserSortDataViewCommand;
    }
    static CreateAddUserLocateDataviewCommand(taskId, userRange) {
        let addUserLocateDataViewCommand = new AddUserLocateDataViewCommand();
        addUserLocateDataViewCommand.TaskTag = taskId;
        addUserLocateDataViewCommand.Range = userRange;
        return addUserLocateDataViewCommand;
    }
    static CreateSetTransactionStateDataviewCommand(taskId, transactionIsOpened) {
        let setTransactionStateDataviewCommand = new SetTransactionStateDataviewCommand();
        setTransactionStateDataviewCommand.TaskTag = taskId;
        setTransactionStateDataviewCommand.TransactionIsOpen = transactionIsOpened;
        return setTransactionStateDataviewCommand;
    }
    static CreateInternalRefreshCommand(taskId, magicEvent, currentRecId, currentRow) {
        let refreshEventCommand = new RefreshEventCommand(magicEvent);
        refreshEventCommand.TaskTag = taskId;
        refreshEventCommand.RefreshMode = ViewRefreshMode.CurrentLocation;
        refreshEventCommand.ClientRecId = currentRecId;
        refreshEventCommand.IsInternalRefresh = true;
        refreshEventCommand.CurrentRecordRow = currentRow;
        return refreshEventCommand;
    }
    static async CreateRealRefreshCommand(taskId, magicEvent, currentRow, argList, currentRecId) {
        let refreshEventCommand = new RefreshEventCommand(magicEvent);
        refreshEventCommand.TaskTag = taskId;
        refreshEventCommand.RefreshMode = ViewRefreshMode.CurrentLocation;
        refreshEventCommand.KeepUserSort = false;
        refreshEventCommand.ClientRecId = currentRecId;
        refreshEventCommand.CurrentRecordRow = currentRow;
        let cmd = refreshEventCommand;
        if (magicEvent !== InternalInterface.MG_ACT_RT_REFRESH_RECORD && argList !== null && argList.getSize() !== 0) {
            try {
                let refreshMode = new NUM_TYPE(await argList.getArgValue(0, StorageAttribute.NUMERIC, 0));
                cmd.RefreshMode = refreshMode.NUM_2_LONG() + 1;
            }
            catch (e) {
                cmd.RefreshMode = ViewRefreshMode.CurrentLocation;
            }
            if (argList.getSize() > 1) {
                try {
                    cmd.KeepUserSort = (await argList.getArgValue(1, StorageAttribute.BOOLEAN, 0) === '1');
                }
                catch (e) {
                    cmd.KeepUserSort = false;
                }
            }
        }
        return cmd;
    }
    static CreatecFetchDataControlValuesCommand(taskTag, controlName) {
        let fetchDataControlValuesEventCommand = new FetchDataControlValuesEventCommand();
        fetchDataControlValuesEventCommand.TaskTag = taskTag;
        fetchDataControlValuesEventCommand.ControlName = controlName;
        return fetchDataControlValuesEventCommand;
    }
    static CreateSubformRefreshCommand(taskTag, subformTaskTag, explicitSubformRefresh) {
        let subformRefreshEventCommand = new SubformRefreshEventCommand();
        subformRefreshEventCommand.TaskTag = taskTag;
        subformRefreshEventCommand.SubformTaskTag = subformTaskTag;
        subformRefreshEventCommand.ExplicitSubformRefresh = explicitSubformRefresh;
        subformRefreshEventCommand.RefreshMode = ViewRefreshMode.UseTaskLocate;
        return subformRefreshEventCommand;
    }
    static CreateSubformOpenCommand(taskTag, subformDitIdx) {
        let subformOpenEventCommand = new SubformOpenEventCommand();
        subformOpenEventCommand.TaskTag = taskTag;
        subformOpenEventCommand.DitIdx = subformDitIdx;
        return subformOpenEventCommand;
    }
    static CreateScreenRefreshCommand(taskTag, topRecIdx, clientRecId) {
        let refreshScreenEventCommand = new RefreshScreenEventCommand();
        refreshScreenEventCommand.TaskTag = taskTag;
        refreshScreenEventCommand.TopRecIdx = topRecIdx;
        refreshScreenEventCommand.RefreshMode = ViewRefreshMode.CurrentLocation;
        refreshScreenEventCommand.ClientRecId = clientRecId;
        return refreshScreenEventCommand;
    }
    static CreateColumnSortCommand(taskTag, direction, ditIdx, fieldId, recId) {
        let columnSortEventCommand = new ColumnSortEventCommand();
        columnSortEventCommand.TaskTag = taskTag;
        columnSortEventCommand.DitIdx = ditIdx;
        columnSortEventCommand.FldId = fieldId + 1;
        columnSortEventCommand.ClientRecId = recId;
        columnSortEventCommand.Direction = direction;
        return columnSortEventCommand;
    }
    static async CreateIndexChangeCommand(taskTag, recId, argList) {
        let indexChangeEventCommand = new IndexChangeEventCommand();
        indexChangeEventCommand.TaskTag = taskTag;
        indexChangeEventCommand.ClientRecId = recId;
        let cmd = indexChangeEventCommand;
        if (argList !== null && argList.getSize() !== 0) {
            try {
                let keyIndex = new NUM_TYPE(await argList.getArgValue(0, StorageAttribute.NUMERIC, 0));
                cmd.KeyIndex = keyIndex.NUM_2_LONG();
            }
            catch (e) {
                cmd.KeyIndex = 0;
            }
        }
        return cmd;
    }
    static CreateBrowserEscEventCommand(taskTag, closeSubformOnly) {
        let browserEscEventCommand = new BrowserEscEventCommand();
        browserEscEventCommand.TaskTag = taskTag;
        browserEscEventCommand.CloseSubformOnly = closeSubformOnly;
        return browserEscEventCommand;
    }
    static CreateComputeEventCommand(taskTag, subforms, clientRecId) {
        let computeEventCommand = new ComputeEventCommand();
        computeEventCommand.TaskTag = taskTag;
        computeEventCommand.Subforms = subforms;
        computeEventCommand.ClientRecId = clientRecId;
        return computeEventCommand;
    }
    static CreateContextTerminationEventCommand(taskTag) {
        let contextTerminationEventCommand = new ContextTerminationEventCommand();
        contextTerminationEventCommand.TaskTag = taskTag;
        return contextTerminationEventCommand;
    }
    static CreateContextTimeoutResetEventCommand() {
        let contextTimeoutResetCommand = new ContextTimeoutResetCommand();
        return contextTimeoutResetCommand;
    }
    static CreateNonReversibleExitCommand(taskTag, closeSubformOnly) {
        let nonReversibleExitEventCommand = new NonReversibleExitEventCommand();
        nonReversibleExitEventCommand.TaskTag = taskTag;
        nonReversibleExitEventCommand.CloseSubformOnly = closeSubformOnly;
        return nonReversibleExitEventCommand;
    }
    static CreateRecomputeCommand(taskTag, fieldId, ignoreSubformRecompute) {
        let recomputeCommand = new RecomputeCommand();
        recomputeCommand.TaskTag = taskTag;
        recomputeCommand.FldId = fieldId;
        recomputeCommand.IgnoreSubformRecompute = ignoreSubformRecompute;
        return recomputeCommand;
    }
    static CreateTransactionCommand(oper, taskTag, cReversibleExit, level) {
        let transactionCommand = new TransactionCommand();
        transactionCommand.TaskTag = taskTag;
        transactionCommand.Oper = oper;
        transactionCommand.ReversibleExit = cReversibleExit;
        transactionCommand.Level = level;
        return transactionCommand;
    }
    static CreateUnloadCommand() {
        return new UnloadCommand();
    }
    static CreateExecOperCommand(taskTag, handlerId, operIdx, ditIdx, value) {
        let execOperCommand = new ExecOperCommand();
        execOperCommand.OperIdx = operIdx;
        execOperCommand.TaskTag = taskTag;
        execOperCommand.HandlerId = handlerId;
        execOperCommand.DitIdx = ditIdx;
        let cmd = execOperCommand;
        if (value !== null && value.length === 0)
            cmd.Val = ' ';
        else
            cmd.Val = value;
        return cmd;
    }
    static CreateSelectProgramCommand(taskTag, handlerId, operIdx, ditIdx, value) {
        let execOperCommand = new SelectProgramCommand();
        execOperCommand.OperIdx = operIdx;
        execOperCommand.TaskTag = taskTag;
        execOperCommand.HandlerId = handlerId;
        execOperCommand.DitIdx = ditIdx;
        let cmd = execOperCommand;
        if (value !== null && value.length === 0)
            cmd.Val = ' ';
        else
            cmd.Val = value;
        return cmd;
    }
    static CreateEvaluateCommand(taskTag, expType, expIdx, expValLen, mprgCreator) {
        let evaluateCommand = new EvaluateCommand();
        evaluateCommand.TaskTag = taskTag;
        evaluateCommand.ExpIdx = expIdx;
        evaluateCommand.ExpType = expType;
        evaluateCommand.MprgCreator = mprgCreator;
        if (expValLen > 0)
            evaluateCommand.LengthExpVal = expValLen;
        return evaluateCommand;
    }
    static CreateQueryGlobalParamsCommand() {
        return new GlobalParamsQueryCommand();
    }
    static CreateIniputForceWriteCommand(param) {
        let iniputForceWriteCommand = new IniputForceWriteCommand();
        iniputForceWriteCommand.Text = param;
        return iniputForceWriteCommand;
    }
}
//# sourceMappingURL=data:application/json;base64,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