import { Int32, StringBuilder } from "@magic-xpa/mscorelib";
import { StorageAttribute, ViewRefreshMode, XMLConstants } from "@magic-xpa/utils";
import { ConstInterface } from "../../ConstInterface";
import { RecordUtils } from "@magic-xpa/gui";
import { AccessHelper } from "../../AccessHelper";
export class CommandSerializationHelper {
    constructor() {
        this.message = new StringBuilder();
    }
    GetString() {
        return this.message.ToString();
    }
    SerializeTaskTag(taskTag) {
        let id = AccessHelper.mgDataTable.getTaskIdById(taskTag);
        this.SerializeAttribute(XMLConstants.MG_ATTR_TASKID, id);
    }
    SerializeFldId(fldId) {
        this.SerializeAttribute(ConstInterface.MG_ATTR_FIELDID, fldId);
    }
    SerializeDitIdx(ditIdx) {
        if (ditIdx > Int32.MinValue) {
            this.SerializeAttribute(XMLConstants.MG_ATTR_DITIDX, ditIdx);
        }
    }
    SerializeRouteParams(operation) {
        let routeParams = operation.getRouteParams();
        let routeValStr = '';
        for (let i = 0; i < routeParams.length; i++) {
            routeValStr = routeValStr.concat(RecordUtils.serializeItemVal(routeParams[i], StorageAttribute.UNICODE, StorageAttribute.SKIP, true));
        }
        this.SerializeAttribute(ConstInterface.MG_ATTR_ROUTE_PARAMS, routeValStr);
    }
    SerializeRefreshMode(refreshMode) {
        if (refreshMode !== ViewRefreshMode.None) {
            this.SerializeAttribute(ConstInterface.MG_ATTR_REALREFRESH, refreshMode);
        }
    }
    SerializeMagicEvent(magicEvent) {
        this.SerializeAttribute(ConstInterface.MG_ATTR_MAGICEVENT, magicEvent);
    }
    SerializeCloseSubformOnly(closeSubformOnly) {
        if (closeSubformOnly)
            this.SerializeAttribute(ConstInterface.MG_ATTR_CLOSE_SUBFORM_ONLY, "1");
    }
    SerializeKeyIndex(keyIndex) {
        this.SerializeAttribute(ConstInterface.MG_ATTR_KEY, keyIndex);
    }
    SerializeAttribute(attribute, value) {
        if (arguments.length === 2 && (attribute === null || attribute.constructor === String) && (value === null || value.constructor === String)) {
            this.SerializeAttribute_0(attribute, value);
            return;
        }
        if (arguments.length === 2 && (attribute === null || attribute.constructor === String) && (value === null || value.constructor === Number)) {
            this.SerializeAttribute_1(attribute, value);
            return;
        }
        this.SerializeAttribute_2(attribute, value);
    }
    SerializeAttribute_0(attribute, value) {
        this.message.Append(" " + attribute + "=\"" + value + "\"");
    }
    SerializeAttribute_1(attribute, value) {
        this.message.Append(" " + attribute + "=\"" + value + "\"");
    }
    SerializeAttribute_2(attribute, value) {
        this.message.Append(" " + attribute + "=\"" + value + "\"");
    }
}
//# sourceMappingURL=data:application/json;base64,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