import { NString } from "@magic-xpa/mscorelib";
import { InternalInterface } from "@magic-xpa/utils";
import { CommandSerializationHelper } from "./CommandSerializationHelper";
import { EventCommand } from "./EventCommand";
import { ConstInterface } from "../../ConstInterface";
export class ComputeEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_COMPUTE);
        this.Subforms = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        if (this.Subforms)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, "99999");
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for {1} in {2}] ', this.EventDescription, this.Subforms ? 'Form and Subform' : 'Form', this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ29tcHV0ZUV2ZW50Q29tbWFuZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL2VuZ2luZS9zcmMvY29tbWFuZHMvQ2xpZW50VG9TZXJ2ZXIvQ29tcHV0ZUV2ZW50Q29tbWFuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUMsT0FBTyxFQUFDLE1BQU0sc0JBQXNCLENBQUM7QUFDN0MsT0FBTyxFQUFDLGlCQUFpQixFQUFDLE1BQU0sa0JBQWtCLENBQUM7QUFDbkQsT0FBTyxFQUFDLDBCQUEwQixFQUFDLE1BQU0sOEJBQThCLENBQUM7QUFDeEUsT0FBTyxFQUFDLFlBQVksRUFBQyxNQUFNLGdCQUFnQixDQUFDO0FBQzVDLE9BQU8sRUFBQyxjQUFjLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUlwRCxNQUFNLE9BQU8sbUJBQW9CLFNBQVEsWUFBWTtJQU9uRDtRQUNFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQU4xQyxhQUFRLEdBQVksS0FBSyxDQUFDO0lBTzFCLENBQUM7SUFFRCxvQkFBb0I7UUFDbEIsSUFBSSxNQUFNLEdBQStCLElBQUksMEJBQTBCLEVBQUUsQ0FBQztRQUUxRSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3RDLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFNUMsSUFBSSxJQUFJLENBQUMsUUFBUTtZQUNmLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRXBFLE9BQU8sTUFBTSxDQUFDLFNBQVMsRUFBRSxDQUFDO0lBQzVCLENBQUM7SUFFRCxjQUFjO1FBQ1osT0FBTyxPQUFPLENBQUMsTUFBTSxDQUFDLHVCQUF1QixFQUNDLElBQUksQ0FBQyxnQkFBZ0IsRUFDdEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLE1BQU0sRUFDMUMsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO0lBQ3pFLENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7TlN0cmluZ30gZnJvbSBcIkBtYWdpYy14cGEvbXNjb3JlbGliXCI7XHJcbmltcG9ydCB7SW50ZXJuYWxJbnRlcmZhY2V9IGZyb20gXCJAbWFnaWMteHBhL3V0aWxzXCI7XHJcbmltcG9ydCB7Q29tbWFuZFNlcmlhbGl6YXRpb25IZWxwZXJ9IGZyb20gXCIuL0NvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyXCI7XHJcbmltcG9ydCB7RXZlbnRDb21tYW5kfSBmcm9tIFwiLi9FdmVudENvbW1hbmRcIjtcclxuaW1wb3J0IHtDb25zdEludGVyZmFjZX0gZnJvbSBcIi4uLy4uL0NvbnN0SW50ZXJmYWNlXCI7XHJcbmltcG9ydCB7SUNsaWVudFRvU2VydmVyQ29tbWFuZEluZm99IGZyb20gXCIuLi9JQ2xpZW50VG9TZXJ2ZXJDb21tYW5kSW5mb1wiO1xyXG5cclxuXHJcbmV4cG9ydCBjbGFzcyBDb21wdXRlRXZlbnRDb21tYW5kIGV4dGVuZHMgRXZlbnRDb21tYW5kIGltcGxlbWVudHMgSUNsaWVudFRvU2VydmVyQ29tbWFuZEluZm8ge1xyXG5cclxuICBTdWJmb3JtczogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vIENUT1JcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGNvbnN0cnVjdG9yKCkge1xyXG4gICAgc3VwZXIoSW50ZXJuYWxJbnRlcmZhY2UuTUdfQUNUX0NPTVBVVEUpO1xyXG4gIH1cclxuXHJcbiAgU2VyaWFsaXplQ29tbWFuZERhdGEoKTogc3RyaW5nIHtcclxuICAgIGxldCBoZWxwZXI6IENvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyID0gbmV3IENvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyKCk7XHJcblxyXG4gICAgaGVscGVyLlNlcmlhbGl6ZVRhc2tUYWcodGhpcy5UYXNrVGFnKTtcclxuICAgIGhlbHBlci5TZXJpYWxpemVNYWdpY0V2ZW50KHRoaXMuTWFnaWNFdmVudCk7XHJcblxyXG4gICAgaWYgKHRoaXMuU3ViZm9ybXMpXHJcbiAgICAgIGhlbHBlci5TZXJpYWxpemVBdHRyaWJ1dGUoQ29uc3RJbnRlcmZhY2UuTUdfQVRUUl9PQkpFQ1QsIFwiOTk5OTlcIik7XHJcblxyXG4gICAgcmV0dXJuIGhlbHBlci5HZXRTdHJpbmcoKTtcclxuICB9XHJcblxyXG4gIGdldENvbW1hbmRJbmZvKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gTlN0cmluZy5Gb3JtYXQoJ1t7MH0gZm9yIHsxfSBpbiB7Mn1dICdcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLCB0aGlzLkV2ZW50RGVzY3JpcHRpb25cclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLHRoaXMuU3ViZm9ybXMgPyAnRm9ybSBhbmQgU3ViZm9ybScgOiAnRm9ybSdcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLCB0aGlzLlRhc2suZ2V0VGFza0luZm8oKSk7XHJcbiAgfVxyXG59XHJcbiJdfQ==