import { Debug, NotImplementedException } from "@magic-xpa/mscorelib";
import { ClientOriginatedCommandTaskTag } from "../ClientOriginatedCommandTaskTag";
export var DataViewCommandType;
(function (DataViewCommandType) {
    DataViewCommandType[DataViewCommandType["Init"] = 0] = "Init";
    DataViewCommandType[DataViewCommandType["Clear"] = 1] = "Clear";
    DataViewCommandType[DataViewCommandType["Prepare"] = 2] = "Prepare";
    DataViewCommandType[DataViewCommandType["FirstChunk"] = 3] = "FirstChunk";
    DataViewCommandType[DataViewCommandType["RecomputeUnit"] = 4] = "RecomputeUnit";
    DataViewCommandType[DataViewCommandType["ExecuteLocalUpdates"] = 5] = "ExecuteLocalUpdates";
    DataViewCommandType[DataViewCommandType["InitDataControlViews"] = 6] = "InitDataControlViews";
    DataViewCommandType[DataViewCommandType["OpenTransaction"] = 7] = "OpenTransaction";
    DataViewCommandType[DataViewCommandType["CloseTransaction"] = 8] = "CloseTransaction";
    DataViewCommandType[DataViewCommandType["SetTransactionState"] = 9] = "SetTransactionState";
    DataViewCommandType[DataViewCommandType["AddUserRange"] = 10] = "AddUserRange";
    DataViewCommandType[DataViewCommandType["ResetUserRange"] = 11] = "ResetUserRange";
    DataViewCommandType[DataViewCommandType["DbDisconnect"] = 12] = "DbDisconnect";
    DataViewCommandType[DataViewCommandType["AddUserLocate"] = 13] = "AddUserLocate";
    DataViewCommandType[DataViewCommandType["ResetUserLocate"] = 14] = "ResetUserLocate";
    DataViewCommandType[DataViewCommandType["AddUserSort"] = 15] = "AddUserSort";
    DataViewCommandType[DataViewCommandType["ResetUserSort"] = 16] = "ResetUserSort";
    DataViewCommandType[DataViewCommandType["DataViewToDataSource"] = 17] = "DataViewToDataSource";
    DataViewCommandType[DataViewCommandType["DbDelete"] = 18] = "DbDelete";
    DataViewCommandType[DataViewCommandType["ControlItemsRefresh"] = 19] = "ControlItemsRefresh";
    DataViewCommandType[DataViewCommandType["SQLExecute"] = 20] = "SQLExecute";
})(DataViewCommandType || (DataViewCommandType = {}));
export class DataviewCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        throw new NotImplementedException();
    }
    SerializeCommandData() {
        Debug.Assert(false, "Dataview commands need not be serialized");
        return null;
    }
    get ShouldSerialize() {
        return false;
    }
    constructor() {
        super();
        this.CommandType = 0;
        this.TaskTag = null;
    }
}
//# sourceMappingURL=data:application/json;base64,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