import { Int32, NString } from '@magic-xpa/mscorelib';
import { StorageAttribute } from '@magic-xpa/utils';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
import { ClientOriginatedCommandTaskTag } from '../ClientOriginatedCommandTaskTag';
export class EvaluateCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_EVAL;
    }
    constructor() {
        super();
        this.TaskTag = null;
        this.ExpIdx = 0;
        this.LengthExpVal = 0;
        this.MprgCreator = null;
        this.LengthExpVal = Int32.MinValue;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_EXP_IDX, this.ExpIdx);
        if (this.ExpType !== StorageAttribute.NONE) {
            let maxDigits = "";
            if (this.LengthExpVal > 0)
                maxDigits += this.LengthExpVal;
            helper.SerializeAttribute(ConstInterface.MG_ATTR_EXP_TYPE, this.ExpType + maxDigits);
        }
        if (this.MprgCreator !== null)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_MPRG_SOURCE, this.MprgCreator.getTaskTag());
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} ExpID {1} in {2}]', this.CommandTypeAttribute.charAt(0).toUpperCase() + this.CommandTypeAttribute.substr(1, this.CommandTypeAttribute.length), this.ExpIdx, this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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