import { NString } from "@magic-xpa/mscorelib";
import { ConstInterface } from "../../ConstInterface";
import { ClientOriginatedCommandTaskTag } from "../ClientOriginatedCommandTaskTag";
import { CommandSerializationHelper } from "./CommandSerializationHelper";
import { AccessHelper } from "../../AccessHelper";
import { Event } from "../../..";
export class EventCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_EVENT;
    }
    get EventDescription() {
        return Event.getInternalEvtDescription(this.MagicEvent);
    }
    get Task() {
        return AccessHelper.mgDataTable.getCurrMGData().getTask(this.TaskTag);
    }
    get ShouldSerialize() {
        if (this.TaskTag !== null && AccessHelper.mgDataTable.GetTaskByID(this.TaskTag) !== null &&
            !AccessHelper.mgDataTable.GetTaskByID(this.TaskTag).KnownToServer)
            return false;
        return true;
    }
    constructor(magicEvent) {
        super();
        this.TaskTag = null;
        this.MagicEvent = 0;
        this.ClientRecId = 0;
        this.MagicEvent = magicEvent;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1}]', this.EventDescription, this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRXZlbnRDb21tYW5kLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy9jb21tYW5kcy9DbGllbnRUb1NlcnZlci9FdmVudENvbW1hbmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFDLE9BQU8sRUFBQyxNQUFNLHNCQUFzQixDQUFDO0FBRTdDLE9BQU8sRUFBQyxjQUFjLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUNwRCxPQUFPLEVBQUMsOEJBQThCLEVBQUMsTUFBTSxtQ0FBbUMsQ0FBQztBQUNqRixPQUFPLEVBQUMsMEJBQTBCLEVBQUMsTUFBTSw4QkFBOEIsQ0FBQztBQUN4RSxPQUFPLEVBQUMsWUFBWSxFQUFDLE1BQU0sb0JBQW9CLENBQUM7QUFFaEQsT0FBTyxFQUFDLEtBQUssRUFBQyxNQUFNLFVBQVUsQ0FBQztBQU0vQixNQUFNLE9BQU8sWUFBYSxTQUFRLDhCQUE4QjtJQU05RCxJQUFJLG9CQUFvQjtRQUN0QixPQUFPLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQztJQUMxQyxDQUFDO0lBRUQsSUFBSSxnQkFBZ0I7UUFDbEIsT0FBTyxLQUFLLENBQUMseUJBQXlCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFRCxJQUFJLElBQUk7UUFDTixPQUFPLFlBQVksQ0FBQyxXQUFXLENBQUMsYUFBYSxFQUFFLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUN4RSxDQUFDO0lBRUQsSUFBSSxlQUFlO1FBQ2pCLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxJQUFJLElBQUksWUFBWSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLElBQUk7WUFDdkYsQ0FBUSxZQUFZLENBQUMsV0FBVyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFFLENBQUMsYUFBYTtZQUN4RSxPQUFPLEtBQUssQ0FBQztRQUNmLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVELFlBQVksVUFBa0I7UUFDNUIsS0FBSyxFQUFFLENBQUM7UUF6QlYsWUFBTyxHQUFXLElBQUksQ0FBQztRQUN2QixlQUFVLEdBQVcsQ0FBQyxDQUFDO1FBQ3ZCLGdCQUFXLEdBQVcsQ0FBQyxDQUFDO1FBd0J0QixJQUFJLENBQUMsVUFBVSxHQUFHLFVBQVUsQ0FBQztJQUMvQixDQUFDO0lBRUQsb0JBQW9CO1FBQ2xCLElBQUksTUFBTSxHQUErQixJQUFJLDBCQUEwQixFQUFFLENBQUM7UUFFMUUsTUFBTSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN0QyxNQUFNLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBRTVDLE9BQU8sTUFBTSxDQUFDLFNBQVMsRUFBRSxDQUFDO0lBQzVCLENBQUM7SUFFRCxjQUFjO1FBQ1osT0FBTyxPQUFPLENBQUMsTUFBTSxDQUFDLGNBQWMsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO0lBQ3hGLENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7TlN0cmluZ30gZnJvbSBcIkBtYWdpYy14cGEvbXNjb3JlbGliXCI7XHJcbmltcG9ydCB7VGFza30gZnJvbSBcIi4uLy4uL3Rhc2tzL1Rhc2tcIjtcclxuaW1wb3J0IHtDb25zdEludGVyZmFjZX0gZnJvbSBcIi4uLy4uL0NvbnN0SW50ZXJmYWNlXCI7XHJcbmltcG9ydCB7Q2xpZW50T3JpZ2luYXRlZENvbW1hbmRUYXNrVGFnfSBmcm9tIFwiLi4vQ2xpZW50T3JpZ2luYXRlZENvbW1hbmRUYXNrVGFnXCI7XHJcbmltcG9ydCB7Q29tbWFuZFNlcmlhbGl6YXRpb25IZWxwZXJ9IGZyb20gXCIuL0NvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyXCI7XHJcbmltcG9ydCB7QWNjZXNzSGVscGVyfSBmcm9tIFwiLi4vLi4vQWNjZXNzSGVscGVyXCI7XHJcbmltcG9ydCB7SUNsaWVudFRvU2VydmVyQ29tbWFuZEluZm99IGZyb20gXCIuLi9JQ2xpZW50VG9TZXJ2ZXJDb21tYW5kSW5mb1wiO1xyXG5pbXBvcnQge0V2ZW50fSBmcm9tIFwiLi4vLi4vLi5cIjtcclxuXHJcblxyXG4vLy8gPHN1bW1hcnk+XHJcbi8vLyBnZW5lcmFsIGNsYXNzIGZvciBldmVudCBjb21tYW5kc1xyXG4vLy8gPC9zdW1tYXJ5PlxyXG5leHBvcnQgY2xhc3MgRXZlbnRDb21tYW5kIGV4dGVuZHMgQ2xpZW50T3JpZ2luYXRlZENvbW1hbmRUYXNrVGFnIGltcGxlbWVudHMgSUNsaWVudFRvU2VydmVyQ29tbWFuZEluZm8ge1xyXG4gIFRhc2tUYWc6IHN0cmluZyA9IG51bGw7XHJcbiAgTWFnaWNFdmVudDogbnVtYmVyID0gMDtcclxuICBDbGllbnRSZWNJZDogbnVtYmVyID0gMDtcclxuXHJcblxyXG4gIGdldCBDb21tYW5kVHlwZUF0dHJpYnV0ZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIENvbnN0SW50ZXJmYWNlLk1HX0FUVFJfVkFMX0VWRU5UO1xyXG4gIH1cclxuXHJcbiAgZ2V0IEV2ZW50RGVzY3JpcHRpb24oKTogc3RyaW5nIHtcclxuICAgIHJldHVybiBFdmVudC5nZXRJbnRlcm5hbEV2dERlc2NyaXB0aW9uKHRoaXMuTWFnaWNFdmVudCk7XHJcbiAgfVxyXG5cclxuICBnZXQgVGFzaygpOiBUYXNrIHtcclxuICAgIHJldHVybiBBY2Nlc3NIZWxwZXIubWdEYXRhVGFibGUuZ2V0Q3Vyck1HRGF0YSgpLmdldFRhc2sodGhpcy5UYXNrVGFnKTtcclxuICB9XHJcblxyXG4gIGdldCBTaG91bGRTZXJpYWxpemUoKTogYm9vbGVhbiB7XHJcbiAgICBpZiAodGhpcy5UYXNrVGFnICE9PSBudWxsICYmIEFjY2Vzc0hlbHBlci5tZ0RhdGFUYWJsZS5HZXRUYXNrQnlJRCh0aGlzLlRhc2tUYWcpICE9PSBudWxsICYmXHJcbiAgICAgISg8VGFzaz5BY2Nlc3NIZWxwZXIubWdEYXRhVGFibGUuR2V0VGFza0J5SUQodGhpcy5UYXNrVGFnKSkuS25vd25Ub1NlcnZlcilcclxuICAgICAgcmV0dXJuIGZhbHNlO1xyXG4gICAgcmV0dXJuIHRydWU7XHJcbiAgfVxyXG5cclxuICBjb25zdHJ1Y3RvcihtYWdpY0V2ZW50OiBudW1iZXIpIHtcclxuICAgIHN1cGVyKCk7XHJcbiAgICB0aGlzLk1hZ2ljRXZlbnQgPSBtYWdpY0V2ZW50O1xyXG4gIH1cclxuXHJcbiAgU2VyaWFsaXplQ29tbWFuZERhdGEoKTogc3RyaW5nIHtcclxuICAgIGxldCBoZWxwZXI6IENvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyID0gbmV3IENvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyKCk7XHJcblxyXG4gICAgaGVscGVyLlNlcmlhbGl6ZVRhc2tUYWcodGhpcy5UYXNrVGFnKTtcclxuICAgIGhlbHBlci5TZXJpYWxpemVNYWdpY0V2ZW50KHRoaXMuTWFnaWNFdmVudCk7XHJcblxyXG4gICAgcmV0dXJuIGhlbHBlci5HZXRTdHJpbmcoKTtcclxuICB9XHJcblxyXG4gIGdldENvbW1hbmRJbmZvKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gTlN0cmluZy5Gb3JtYXQoJ1t7MH0gaW4gezF9XScsIHRoaXMuRXZlbnREZXNjcmlwdGlvbiwgdGhpcy5UYXNrLmdldFRhc2tJbmZvKCkpO1xyXG4gIH1cclxufVxyXG4iXX0=