import { Int32, StringBuilder } from "@magic-xpa/mscorelib";
import { XMLConstants, XmlParser, } from "@magic-xpa/utils";
import { ExecutionStack } from "../../rt/ExecutionStack";
import { ConstInterface } from "../../ConstInterface";
import { CommandSerializationHelper } from "./CommandSerializationHelper";
import { ClientOriginatedCommandTaskTag } from "../ClientOriginatedCommandTaskTag";
import { AccessHelper } from "../../AccessHelper";
export class ExecOperCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_EXEC_OPER;
    }
    constructor() {
        super();
        this.ExecutionStack = null;
        this.TaskTag = null;
        this.HandlerId = null;
        this.OperIdx = 0;
        this.DitIdx = 0;
        this.Val = null;
        this.MprgCreator = null;
        this.Operation = null;
        this.CheckOnly = false;
        this.DitIdx = Int32.MinValue;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        let execStackExists = this.ExecutionStack !== null && !this.ExecutionStack.empty();
        helper.SerializeTaskTag(this.TaskTag);
        if (this.HandlerId !== null && !execStackExists)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_HANDLERID, this.HandlerId);
        if (this.OperIdx > Int32.MinValue && !execStackExists)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_OPER_IDX, this.OperIdx);
        if (this.DitIdx > Int32.MinValue)
            helper.SerializeDitIdx(this.DitIdx);
        if (this.Operation != null && this.Operation.getType() === ConstInterface.MG_OPER_CALL && this.Operation.getRouteParams() !== null) {
            helper.SerializeRouteParams(this.Operation);
        }
        if (this.Val !== null)
            helper.SerializeAttribute(XMLConstants.MG_ATTR_VALUE, XmlParser.escape(this.Val));
        if (this.CheckOnly)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_CHECK_ONLY, "1");
        return helper.GetString();
    }
    SetExecutionStack(execStack) {
        this.ExecutionStack = new ExecutionStack();
        this.ExecutionStack.push(AccessHelper.mgDataTable.getTaskIdById(this.TaskTag), this.HandlerId, this.OperIdx);
        this.ExecutionStack.pushUpSideDown(execStack);
    }
    SerializeDataAfterCommand() {
        let execStackExists = this.ExecutionStack !== null && !this.ExecutionStack.empty();
        if (execStackExists) {
            let message = new StringBuilder();
            this.ExecutionStack.buildXML(message);
            return message.ToString();
        }
        return null;
    }
    getCommandInfo() {
        return 'Line number ' + '[' + (this.Operation.getServerId() + 1) + ']' +
            ' in ' + '[' + this.Operation.getEventHandler().getEventHandlerInfo() + ']' +
            ' on ' + '[' + this.Operation.Task.getTaskInfo() + ']';
    }
    getTask() {
        return this.Operation.Task;
    }
}
//# sourceMappingURL=data:application/json;base64,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