import { InternalInterface } from '@magic-xpa/utils';
import { NString } from '@magic-xpa/mscorelib';
import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
export class FetchDataControlValuesEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_FETCH_DATA_CONTROL_VALUES);
        this.ControlName = null;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_CONTROL_NAME, this.ControlName);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for control {1} in {2}]', this.EventDescription, this.ControlName, this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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