import { InternalInterface } from '@magic-xpa/utils';
import { NString } from '@magic-xpa/mscorelib';
import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
export class IndexChangeEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_INDEX_CHANGE);
        this.KeyIndex = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeKeyIndex(this.KeyIndex);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} with Key Index {1} in {2}]', this.EventDescription, this.KeyIndex, this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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