import { XmlParser } from "@magic-xpa/utils";
import { NString } from "@magic-xpa/mscorelib";
import { ConstInterface } from "../../ConstInterface";
import { ClientOriginatedCommand } from "./ClientOriginatedCommand";
export class IniputForceWriteCommand extends ClientOriginatedCommand {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_INIPUT_FORCE_WRITE;
    }
    get ShouldSerializeRecords() {
        return false;
    }
    SerializeCommandData() {
        return " " + ConstInterface.MG_ATTR_VAL_INIPUT_PARAM + "=\"" + XmlParser.escape(this.Text) + "\"";
    }
    constructor() {
        super();
        this.Text = null;
    }
    getCommandInfo() {
        return NString.Format('[{0} with {1}] ', this.CommandTypeAttribute, this.Text);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSW5pcHV0Rm9yY2VXcml0ZUNvbW1hbmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9lbmdpbmUvc3JjL2NvbW1hbmRzL0NsaWVudFRvU2VydmVyL0luaXB1dEZvcmNlV3JpdGVDb21tYW5kLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBQyxTQUFTLEVBQUMsTUFBTSxrQkFBa0IsQ0FBQztBQUMzQyxPQUFPLEVBQUMsT0FBTyxFQUFDLE1BQU0sc0JBQXNCLENBQUM7QUFDN0MsT0FBTyxFQUFDLGNBQWMsRUFBQyxNQUFNLHNCQUFzQixDQUFDO0FBQ3BELE9BQU8sRUFBQyx1QkFBdUIsRUFBQyxNQUFNLDJCQUEyQixDQUFDO0FBR2xFLE1BQU0sT0FBTyx1QkFBd0IsU0FBUSx1QkFBdUI7SUFHbEUsSUFBSSxvQkFBb0I7UUFDdEIsT0FBTyxjQUFjLENBQUMsOEJBQThCLENBQUM7SUFDdkQsQ0FBQztJQUVELElBQUksc0JBQXNCO1FBQ3hCLE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVELG9CQUFvQjtRQUNsQixPQUFPLEdBQUcsR0FBRyxjQUFjLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxHQUFHLFNBQVMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQztJQUNwRyxDQUFDO0lBRUQ7UUFDRSxLQUFLLEVBQUUsQ0FBQztRQWZWLFNBQUksR0FBVyxJQUFJLENBQUM7SUFnQnBCLENBQUM7SUFFRCxjQUFjO1FBQ1osT0FBTyxPQUFPLENBQUMsTUFBTSxDQUFDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDakYsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtYbWxQYXJzZXJ9IGZyb20gXCJAbWFnaWMteHBhL3V0aWxzXCI7XHJcbmltcG9ydCB7TlN0cmluZ30gZnJvbSBcIkBtYWdpYy14cGEvbXNjb3JlbGliXCI7XHJcbmltcG9ydCB7Q29uc3RJbnRlcmZhY2V9IGZyb20gXCIuLi8uLi9Db25zdEludGVyZmFjZVwiO1xyXG5pbXBvcnQge0NsaWVudE9yaWdpbmF0ZWRDb21tYW5kfSBmcm9tIFwiLi9DbGllbnRPcmlnaW5hdGVkQ29tbWFuZFwiO1xyXG5pbXBvcnQge0lDbGllbnRUb1NlcnZlckNvbW1hbmRJbmZvfSBmcm9tIFwiLi4vSUNsaWVudFRvU2VydmVyQ29tbWFuZEluZm9cIjtcclxuXHJcbmV4cG9ydCBjbGFzcyBJbmlwdXRGb3JjZVdyaXRlQ29tbWFuZCBleHRlbmRzIENsaWVudE9yaWdpbmF0ZWRDb21tYW5kIGltcGxlbWVudHMgSUNsaWVudFRvU2VydmVyQ29tbWFuZEluZm8ge1xyXG4gIFRleHQ6IHN0cmluZyA9IG51bGw7XHJcblxyXG4gIGdldCBDb21tYW5kVHlwZUF0dHJpYnV0ZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIENvbnN0SW50ZXJmYWNlLk1HX0FUVFJfVkFMX0lOSVBVVF9GT1JDRV9XUklURTtcclxuICB9XHJcblxyXG4gIGdldCBTaG91bGRTZXJpYWxpemVSZWNvcmRzKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIGZhbHNlO1xyXG4gIH1cclxuXHJcbiAgU2VyaWFsaXplQ29tbWFuZERhdGEoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiBcIiBcIiArIENvbnN0SW50ZXJmYWNlLk1HX0FUVFJfVkFMX0lOSVBVVF9QQVJBTSArIFwiPVxcXCJcIiArIFhtbFBhcnNlci5lc2NhcGUodGhpcy5UZXh0KSArIFwiXFxcIlwiO1xyXG4gIH1cclxuXHJcbiAgY29uc3RydWN0b3IoKSB7XHJcbiAgICBzdXBlcigpO1xyXG4gIH1cclxuXHJcbiAgZ2V0Q29tbWFuZEluZm8oKTogc3RyaW5nIHtcclxuICAgIHJldHVybiBOU3RyaW5nLkZvcm1hdCgnW3swfSB3aXRoIHsxfV0gJywgdGhpcy5Db21tYW5kVHlwZUF0dHJpYnV0ZSwgdGhpcy5UZXh0KTtcclxuICB9XHJcbn1cclxuIl19