import { InternalInterface } from '@magic-xpa/utils';
import { NString } from '@magic-xpa/mscorelib';
import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
export class NonReversibleExitEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_EXIT);
        this.CloseSubformOnly = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_REVERSIBLE, "0");
        helper.SerializeCloseSubformOnly(this.CloseSubformOnly);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0}{1} in {2}]', this.EventDescription, this.CloseSubformOnly ? ' Closing Subform Only' : NString.Empty, this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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