import { NString } from '@magic-xpa/mscorelib';
import { ConstInterface } from '../../ConstInterface';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ClientOriginatedCommandTaskTag } from '../ClientOriginatedCommandTaskTag';
export class RecomputeCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_RECOMP;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeFldId(this.FldId);
        if (this.IgnoreSubformRecompute)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_IGNORE_SUBFORM_RECOMPUTE, '1');
        return helper.GetString();
    }
    constructor() {
        super();
        this.TaskTag = null;
        this.FldId = 0;
        this.IgnoreSubformRecompute = false;
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1} for Field {2}]', this.CommandTypeAttribute.charAt(0).toUpperCase() + this.CommandTypeAttribute.substr(1, this.CommandTypeAttribute.length), this.Task.getTaskInfo(), this.Task.getFieldDef(this.FldId).getName());
    }
}
//# sourceMappingURL=data:application/json;base64,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