import { NString } from '@magic-xpa/mscorelib';
import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
export class RefreshEventCommand extends EventCommand {
    constructor(magicEvent) {
        super(magicEvent);
        this.RefreshMode = 0;
        this.KeepUserSort = false;
        this.CurrentRecordRow = 0;
        this.IsInternalRefresh = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        if (!this.IsInternalRefresh)
            helper.SerializeRefreshMode(this.RefreshMode);
        if (this.KeepUserSort)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_KEEP_USER_SORT, "1");
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} {1}]', this.EventDescription, this.IsInternalRefresh ? 'Raised by Magic' : 'Raised by User');
    }
}
//# sourceMappingURL=data:application/json;base64,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