import { InternalInterface } from '@magic-xpa/utils';
import { NString } from '@magic-xpa/mscorelib';
import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
export class RefreshScreenEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_RT_REFRESH_SCREEN);
        this.TopRecIdx = 0;
        this.RefreshMode = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, this.TopRecIdx);
        helper.SerializeRefreshMode(this.RefreshMode);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1}]', this.EventDescription, this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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