import { NString } from '@magic-xpa/mscorelib';
import { InternalInterface } from '@magic-xpa/utils';
import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
export var RollbackEventCommand_RollbackType;
(function (RollbackEventCommand_RollbackType) {
    RollbackEventCommand_RollbackType["NONE"] = " ";
    RollbackEventCommand_RollbackType["CANCEL"] = "C";
    RollbackEventCommand_RollbackType["ROLLBACK"] = "R";
})(RollbackEventCommand_RollbackType || (RollbackEventCommand_RollbackType = {}));
export class RollbackEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_ROLLBACK);
        this.Rollback = RollbackEventCommand_RollbackType.NONE;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        if (this.Rollback !== RollbackEventCommand_RollbackType.NONE)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_ROLLBACK_TYPE, this.Rollback);
        return helper.GetString();
    }
    getRollbackTypeString() {
        switch (this.Rollback) {
            case RollbackEventCommand_RollbackType.CANCEL:
                return 'Cancel';
            case RollbackEventCommand_RollbackType.ROLLBACK:
                return 'Rollback';
        }
    }
    getCommandInfo() {
        return NString.Format('[{0}{1} in {2}]', this.EventDescription, NString.IsNullOrEmpty(this.getRollbackTypeString())
            ? NString.Empty
            : NString.Format(' while handling {0}', this.getRollbackTypeString()), this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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