import { InternalInterface } from '@magic-xpa/utils';
import { EventCommand } from './EventCommand';
import { NString } from '@magic-xpa/mscorelib';
import { CommandSerializationHelper } from './CommandSerializationHelper';
export class SubformOpenEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_SUBFORM_OPEN);
        this.DitIdx = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeDitIdx(this.DitIdx);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} {1} in {2}]', this.EventDescription, this.Task.getForm().getCtrl(this.DitIdx).getName(), this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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