import { RefreshEventCommand } from './RefreshEventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { NString } from '@magic-xpa/mscorelib';
import { InternalInterface } from '@magic-xpa/utils';
import { ConstInterface } from '../../ConstInterface';
export class SubformRefreshEventCommand extends RefreshEventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_SUBFORM_REFRESH);
        this.SubformTaskTag = null;
        this.ExplicitSubformRefresh = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeRefreshMode(this.RefreshMode);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_SUBFORM_TASK, this.SubformTaskTag);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for {1}]', this.EventDescription, this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3ViZm9ybVJlZnJlc2hFdmVudENvbW1hbmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9lbmdpbmUvc3JjL2NvbW1hbmRzL0NsaWVudFRvU2VydmVyL1N1YmZvcm1SZWZyZXNoRXZlbnRDb21tYW5kLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBQyxtQkFBbUIsRUFBQyxNQUFNLHVCQUF1QixDQUFDO0FBQzFELE9BQU8sRUFBQywwQkFBMEIsRUFBQyxNQUFNLDhCQUE4QixDQUFDO0FBQ3hFLE9BQU8sRUFBQyxPQUFPLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUM3QyxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSxrQkFBa0IsQ0FBQztBQUNuRCxPQUFPLEVBQUMsY0FBYyxFQUFDLE1BQU0sc0JBQXNCLENBQUM7QUFHcEQsTUFBTSxPQUFPLDBCQUEyQixTQUFRLG1CQUFtQjtJQU9qRTtRQUNFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBUGxELG1CQUFjLEdBQVcsSUFBSSxDQUFDO1FBQzlCLDJCQUFzQixHQUFZLEtBQUssQ0FBQztJQU94QyxDQUFDO0lBRUQsb0JBQW9CO1FBQ2xCLElBQUksTUFBTSxHQUErQixJQUFJLDBCQUEwQixFQUFFLENBQUM7UUFFMUUsTUFBTSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN0QyxNQUFNLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQzVDLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDOUMsTUFBTSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFFcEYsT0FBTyxNQUFNLENBQUMsU0FBUyxFQUFFLENBQUM7SUFDNUIsQ0FBQztJQUVELGNBQWM7UUFDWixPQUFPLE9BQU8sQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFDZCxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7SUFDMUUsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtSZWZyZXNoRXZlbnRDb21tYW5kfSBmcm9tICcuL1JlZnJlc2hFdmVudENvbW1hbmQnO1xyXG5pbXBvcnQge0NvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyfSBmcm9tICcuL0NvbW1hbmRTZXJpYWxpemF0aW9uSGVscGVyJztcclxuaW1wb3J0IHtOU3RyaW5nfSBmcm9tICdAbWFnaWMteHBhL21zY29yZWxpYic7XHJcbmltcG9ydCB7SW50ZXJuYWxJbnRlcmZhY2V9IGZyb20gJ0BtYWdpYy14cGEvdXRpbHMnO1xyXG5pbXBvcnQge0NvbnN0SW50ZXJmYWNlfSBmcm9tICcuLi8uLi9Db25zdEludGVyZmFjZSc7XHJcbmltcG9ydCB7SUNsaWVudFRvU2VydmVyQ29tbWFuZEluZm99IGZyb20gJy4uL0lDbGllbnRUb1NlcnZlckNvbW1hbmRJbmZvJztcclxuXHJcbmV4cG9ydCBjbGFzcyBTdWJmb3JtUmVmcmVzaEV2ZW50Q29tbWFuZCBleHRlbmRzIFJlZnJlc2hFdmVudENvbW1hbmQgaW1wbGVtZW50cyBJQ2xpZW50VG9TZXJ2ZXJDb21tYW5kSW5mbyB7XHJcbiAgU3ViZm9ybVRhc2tUYWc6IHN0cmluZyA9IG51bGw7XHJcbiAgRXhwbGljaXRTdWJmb3JtUmVmcmVzaDogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vIENUT1JcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGNvbnN0cnVjdG9yKCkge1xyXG4gICAgc3VwZXIoSW50ZXJuYWxJbnRlcmZhY2UuTUdfQUNUX1NVQkZPUk1fUkVGUkVTSCk7XHJcbiAgfVxyXG5cclxuICBTZXJpYWxpemVDb21tYW5kRGF0YSgpOiBzdHJpbmcge1xyXG4gICAgbGV0IGhlbHBlcjogQ29tbWFuZFNlcmlhbGl6YXRpb25IZWxwZXIgPSBuZXcgQ29tbWFuZFNlcmlhbGl6YXRpb25IZWxwZXIoKTtcclxuXHJcbiAgICBoZWxwZXIuU2VyaWFsaXplVGFza1RhZyh0aGlzLlRhc2tUYWcpO1xyXG4gICAgaGVscGVyLlNlcmlhbGl6ZU1hZ2ljRXZlbnQodGhpcy5NYWdpY0V2ZW50KTtcclxuICAgIGhlbHBlci5TZXJpYWxpemVSZWZyZXNoTW9kZSh0aGlzLlJlZnJlc2hNb2RlKTtcclxuICAgIGhlbHBlci5TZXJpYWxpemVBdHRyaWJ1dGUoQ29uc3RJbnRlcmZhY2UuTUdfQVRUUl9TVUJGT1JNX1RBU0ssIHRoaXMuU3ViZm9ybVRhc2tUYWcpO1xyXG5cclxuICAgIHJldHVybiBoZWxwZXIuR2V0U3RyaW5nKCk7XHJcbiAgfVxyXG5cclxuICBnZXRDb21tYW5kSW5mbygpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIE5TdHJpbmcuRm9ybWF0KCdbezB9IGZvciB7MX1dJyAsIHRoaXMuRXZlbnREZXNjcmlwdGlvblxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLCB0aGlzLlRhc2suZ2V0VGFza0luZm8oKSk7XHJcbiAgfVxyXG59XHJcbiJdfQ==