import { NString } from '@magic-xpa/mscorelib';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
import { ClientOriginatedCommandTaskTag } from '../ClientOriginatedCommandTaskTag';
export class TransactionCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_TRANS;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OPER, this.Oper);
        if (!this.ReversibleExit)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_REVERSIBLE, "0");
        if (this.Level !== '\0')
            helper.SerializeAttribute(ConstInterface.MG_ATTR_TRANS_LEVEL, this.Level);
        return helper.GetString();
    }
    constructor() {
        super();
        this.TaskTag = null;
        this.ReversibleExit = false;
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1}]', this.Oper === 'C' ? 'Commit Transaction' : 'Abort Transaction', this.Task.getTaskInfo());
    }
}
//# sourceMappingURL=data:application/json;base64,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