import { InternalInterface } from '@magic-xpa/utils';
import { EventCommand } from './EventCommand';
import { CommandSerializationHelper } from './CommandSerializationHelper';
import { ConstInterface } from '../../ConstInterface';
export class WriteMessageToServerLogCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_WRITE_ERROR_TO_SERVER_LOG);
        this.ErrorMessage = null;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_ERROR_MESSAGE, this.ErrorMessage);
        return helper.GetString();
    }
}
//# sourceMappingURL=data:application/json;base64,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