import { ClientTargetedCommandBase } from "./ClientTargetedCommandBase";
import { Debug } from "@magic-xpa/mscorelib";
import { GUIManager } from "../../GUIManager";
import { MgControl } from "../../gui/MgControl";
import { ConstInterface } from "../../ConstInterface";
import { XMLConstants } from "@magic-xpa/utils";
import { LastFocusedManager } from "../../rt/LastFocusedManager";
import { AccessHelper } from "../../AccessHelper";
export class AbortCommand extends ClientTargetedCommandBase {
    constructor(taskTag) {
        super();
        this._transOwner = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(taskTag);
    }
    constructor_0() {
    }
    constructor_1(taskTag) {
        this.TaskTag = taskTag;
    }
    async Execute(res) {
        let currMgdID = AccessHelper.mgDataTable.currMgdID;
        let task = AccessHelper.mgDataTable.GetTaskByID(this.TaskTag);
        if (this._transOwner !== null) {
            let newTransOwnerTask = AccessHelper.mgDataTable.GetTaskByID(this._transOwner);
            if (newTransOwnerTask !== null)
                newTransOwnerTask.setTransOwnerTask();
        }
        if ((task === null && AccessHelper.eventsManager.ignoreUnknownAbort()))
            return;
        Debug.Assert(task !== null);
        let mGData = task.getMGData();
        await task.stop();
        mGData.abort();
        AccessHelper.mgDataTable.currMgdID = mGData.GetId();
        let form = task.getForm();
        GUIManager.Instance.abort(form);
        AccessHelper.mgDataTable.currMgdID = ((mGData.GetId() !== currMgdID || mGData.getParentMGdata() === null)
            ? currMgdID
            : mGData.getParentMGdata().GetId());
        if (!MgControl.validReturnToCtrl()) {
            let lastFocusedControl = LastFocusedManager.getLastFocusedControl();
            MgControl.ReturnToCtrl = lastFocusedControl;
        }
    }
    HandleAttribute(attribute, value) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_TRANS_OWNER:
                this._transOwner = value;
                break;
            default:
                super.HandleAttribute(attribute, value);
                break;
        }
        if (attribute === XMLConstants.MG_ATTR_TASKID) {
            let abortingTask = AccessHelper.mgDataTable.GetTaskByID(this.TaskTag);
            if (abortingTask != null)
                abortingTask.resetKnownToServer();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQWJvcnRDb21tYW5kLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy9jb21tYW5kcy9TZXJ2ZXJUb0NsaWVudC9BYm9ydENvbW1hbmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFDLHlCQUF5QixFQUFDLE1BQU0sNkJBQTZCLENBQUM7QUFHdEUsT0FBTyxFQUFDLEtBQUssRUFBQyxNQUFNLHNCQUFzQixDQUFDO0FBRTNDLE9BQU8sRUFBQyxVQUFVLEVBQUMsTUFBTSxrQkFBa0IsQ0FBQztBQUU1QyxPQUFPLEVBQUMsU0FBUyxFQUFDLE1BQU0scUJBQXFCLENBQUM7QUFDOUMsT0FBTyxFQUFDLGNBQWMsRUFBQyxNQUFNLHNCQUFzQixDQUFDO0FBQ3BELE9BQU8sRUFBQyxZQUFZLEVBQUMsTUFBTSxrQkFBa0IsQ0FBQztBQUM5QyxPQUFPLEVBQUMsa0JBQWtCLEVBQUUsTUFBTSw2QkFBNkIsQ0FBQztBQUNoRSxPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0sb0JBQW9CLENBQUM7QUFFbEQsTUFBTSxPQUFPLFlBQWEsU0FBUSx5QkFBeUI7SUFNekQsWUFBWSxPQUFnQjtRQUMxQixLQUFLLEVBQUUsQ0FBQztRQUxGLGdCQUFXLEdBQVcsSUFBSSxDQUFDO1FBT2pDLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDMUIsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQ3JCLE9BQU87U0FDUjtRQUNELElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVPLGFBQWE7SUFDckIsQ0FBQztJQUVPLGFBQWEsQ0FBQyxPQUFlO1FBQ25DLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0lBQ3pCLENBQUM7SUFFRCxLQUFLLENBQUMsT0FBTyxDQUFDLEdBQWlCO1FBQzdCLElBQUksU0FBUyxHQUFXLFlBQVksQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDO1FBQzNELElBQUksSUFBSSxHQUFlLFlBQVksQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUcxRSxJQUFJLElBQUksQ0FBQyxXQUFXLEtBQUssSUFBSSxFQUFFO1lBQzdCLElBQUksaUJBQWlCLEdBQWUsWUFBWSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1lBQzNGLElBQUksaUJBQWlCLEtBQUssSUFBSTtnQkFDNUIsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztTQUN6QztRQUdELElBQUksQ0FBQyxJQUFJLEtBQUssSUFBSSxJQUFJLFlBQVksQ0FBQyxhQUFhLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztZQUNwRSxPQUFPO1FBRVQsS0FBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssSUFBSSxDQUFDLENBQUM7UUFDNUIsSUFBSSxNQUFNLEdBQVcsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBQ3RDLE1BQU0sSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ2xCLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUVmLFlBQVksQ0FBQyxXQUFXLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUVwRCxJQUFJLElBQUksR0FBVyxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7UUFFbEMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFaEMsWUFBWSxDQUFDLFdBQVcsQ0FBQyxTQUFTLEdBQUcsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsS0FBSyxTQUFTLElBQUksTUFBTSxDQUFDLGVBQWUsRUFBRSxLQUFLLElBQUksQ0FBQztZQUNqRSxDQUFDLENBQUMsU0FBUztZQUNYLENBQUMsQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUU1RSxJQUFJLENBQUMsU0FBUyxDQUFDLGlCQUFpQixFQUFFLEVBQUU7WUFDbEMsSUFBSSxrQkFBa0IsR0FBYyxrQkFBa0IsQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO1lBQy9FLFNBQVMsQ0FBQyxZQUFZLEdBQUcsa0JBQWtCLENBQUM7U0FDN0M7SUFDSCxDQUFDO0lBRU0sZUFBZSxDQUFDLFNBQWlCLEVBQUUsS0FBYTtRQUNyRCxRQUFRLFNBQVMsRUFBRTtZQUNqQixLQUFLLGNBQWMsQ0FBQyxtQkFBbUI7Z0JBQ3JDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO2dCQUN6QixNQUFNO1lBRVI7Z0JBQ0UsS0FBSyxDQUFDLGVBQWUsQ0FBQyxTQUFTLEVBQUUsS0FBSyxDQUFDLENBQUM7Z0JBQ3hDLE1BQU07U0FDVDtRQUdELElBQUksU0FBUyxLQUFLLFlBQVksQ0FBQyxjQUFjLEVBQUU7WUFDN0MsSUFBSSxZQUFZLEdBQVMsWUFBWSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQzVFLElBQUksWUFBWSxJQUFJLElBQUk7Z0JBQ3RCLFlBQVksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1NBQ3JDO0lBQ0gsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtDbGllbnRUYXJnZXRlZENvbW1hbmRCYXNlfSBmcm9tIFwiLi9DbGllbnRUYXJnZXRlZENvbW1hbmRCYXNlXCI7XHJcbmltcG9ydCB7SVJlc3VsdFZhbHVlfSBmcm9tIFwiLi4vLi4vcnQvSVJlc3VsdFZhbHVlXCI7XHJcbmltcG9ydCB7VGFza30gZnJvbSBcIi4uLy4uL3Rhc2tzL1Rhc2tcIjtcclxuaW1wb3J0IHtEZWJ1Z30gZnJvbSBcIkBtYWdpYy14cGEvbXNjb3JlbGliXCI7XHJcbmltcG9ydCB7TUdEYXRhfSBmcm9tIFwiLi4vLi4vdGFza3MvTUdEYXRhXCI7XHJcbmltcG9ydCB7R1VJTWFuYWdlcn0gZnJvbSBcIi4uLy4uL0dVSU1hbmFnZXJcIjtcclxuaW1wb3J0IHtNZ0Zvcm19IGZyb20gXCIuLi8uLi9ndWkvTWdGb3JtXCI7XHJcbmltcG9ydCB7TWdDb250cm9sfSBmcm9tIFwiLi4vLi4vZ3VpL01nQ29udHJvbFwiO1xyXG5pbXBvcnQge0NvbnN0SW50ZXJmYWNlfSBmcm9tIFwiLi4vLi4vQ29uc3RJbnRlcmZhY2VcIjtcclxuaW1wb3J0IHtYTUxDb25zdGFudHN9IGZyb20gXCJAbWFnaWMteHBhL3V0aWxzXCI7XHJcbmltcG9ydCB7TGFzdEZvY3VzZWRNYW5hZ2VyIH0gZnJvbSBcIi4uLy4uL3J0L0xhc3RGb2N1c2VkTWFuYWdlclwiO1xyXG5pbXBvcnQgeyBBY2Nlc3NIZWxwZXIgfSBmcm9tIFwiLi4vLi4vQWNjZXNzSGVscGVyXCI7XHJcblxyXG5leHBvcnQgY2xhc3MgQWJvcnRDb21tYW5kIGV4dGVuZHMgQ2xpZW50VGFyZ2V0ZWRDb21tYW5kQmFzZSB7XHJcblxyXG4gIHByaXZhdGUgX3RyYW5zT3duZXI6IHN0cmluZyA9IG51bGw7XHJcblxyXG4gIGNvbnN0cnVjdG9yKCk7XHJcbiAgY29uc3RydWN0b3IodGFza1RhZzogc3RyaW5nKTtcclxuICBjb25zdHJ1Y3Rvcih0YXNrVGFnPzogc3RyaW5nKSB7XHJcbiAgICBzdXBlcigpO1xyXG5cclxuICAgIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAwKSB7XHJcbiAgICAgIHRoaXMuY29uc3RydWN0b3JfMCgpO1xyXG4gICAgICByZXR1cm47XHJcbiAgICB9XHJcbiAgICB0aGlzLmNvbnN0cnVjdG9yXzEodGFza1RhZyk7XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGNvbnN0cnVjdG9yXzAoKTogdm9pZCB7XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGNvbnN0cnVjdG9yXzEodGFza1RhZzogc3RyaW5nKTogdm9pZCB7XHJcbiAgICB0aGlzLlRhc2tUYWcgPSB0YXNrVGFnO1xyXG4gIH1cclxuXHJcbiAgYXN5bmMgRXhlY3V0ZShyZXM6IElSZXN1bHRWYWx1ZSk6IFByb21pc2U8dm9pZD4ge1xyXG4gICAgbGV0IGN1cnJNZ2RJRDogbnVtYmVyID0gQWNjZXNzSGVscGVyLm1nRGF0YVRhYmxlLmN1cnJNZ2RJRDtcclxuICAgIGxldCB0YXNrOiBUYXNrID0gPFRhc2s+QWNjZXNzSGVscGVyLm1nRGF0YVRhYmxlLkdldFRhc2tCeUlEKHRoaXMuVGFza1RhZyk7XHJcblxyXG4gICAgLy8gUGFzcyB0cmFuc2FjdGlvbiBvd25lcnNoaXBcclxuICAgIGlmICh0aGlzLl90cmFuc093bmVyICE9PSBudWxsKSB7XHJcbiAgICAgIGxldCBuZXdUcmFuc093bmVyVGFzazogVGFzayA9IDxUYXNrPkFjY2Vzc0hlbHBlci5tZ0RhdGFUYWJsZS5HZXRUYXNrQnlJRCh0aGlzLl90cmFuc093bmVyKTtcclxuICAgICAgaWYgKG5ld1RyYW5zT3duZXJUYXNrICE9PSBudWxsKVxyXG4gICAgICAgIG5ld1RyYW5zT3duZXJUYXNrLnNldFRyYW5zT3duZXJUYXNrKCk7XHJcbiAgICB9XHJcblxyXG4gICAgLy8gT24gc3BlY2lhbCBvY2Nhc2lvbnMsIHRoZSBzZXJ2ZXIgbWF5IHNlbmQgYWJvcnQgY29tbWFuZHMgb24gdGFza3Mgd2hpY2ggd2VyZSBub3QgcGFyc2VkIHlldFxyXG4gICAgaWYgKCh0YXNrID09PSBudWxsICYmIEFjY2Vzc0hlbHBlci5ldmVudHNNYW5hZ2VyLmlnbm9yZVVua25vd25BYm9ydCgpKSlcclxuICAgICAgcmV0dXJuO1xyXG5cclxuICAgIERlYnVnLkFzc2VydCh0YXNrICE9PSBudWxsKTtcclxuICAgIGxldCBtR0RhdGE6IE1HRGF0YSA9IHRhc2suZ2V0TUdEYXRhKCk7XHJcbiAgICBhd2FpdCB0YXNrLnN0b3AoKTtcclxuICAgIG1HRGF0YS5hYm9ydCgpO1xyXG5cclxuICAgIEFjY2Vzc0hlbHBlci5tZ0RhdGFUYWJsZS5jdXJyTWdkSUQgPSBtR0RhdGEuR2V0SWQoKTtcclxuXHJcbiAgICBsZXQgZm9ybSA9IDxNZ0Zvcm0+dGFzay5nZXRGb3JtKCk7XHJcblxyXG4gICAgR1VJTWFuYWdlci5JbnN0YW5jZS5hYm9ydChmb3JtKTtcclxuXHJcbiAgICBBY2Nlc3NIZWxwZXIubWdEYXRhVGFibGUuY3Vyck1nZElEID0gKChtR0RhdGEuR2V0SWQoKSAhPT0gY3Vyck1nZElEIHx8IG1HRGF0YS5nZXRQYXJlbnRNR2RhdGEoKSA9PT0gbnVsbClcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA/IGN1cnJNZ2RJRFxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDogbUdEYXRhLmdldFBhcmVudE1HZGF0YSgpLkdldElkKCkpO1xyXG5cclxuICAgIGlmICghTWdDb250cm9sLnZhbGlkUmV0dXJuVG9DdHJsKCkpIHtcclxuICAgICAgbGV0IGxhc3RGb2N1c2VkQ29udHJvbDogTWdDb250cm9sID0gTGFzdEZvY3VzZWRNYW5hZ2VyLmdldExhc3RGb2N1c2VkQ29udHJvbCgpO1xyXG4gICAgICBNZ0NvbnRyb2wuUmV0dXJuVG9DdHJsID0gbGFzdEZvY3VzZWRDb250cm9sO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIEhhbmRsZUF0dHJpYnV0ZShhdHRyaWJ1dGU6IHN0cmluZywgdmFsdWU6IHN0cmluZyk6IHZvaWQge1xyXG4gICAgc3dpdGNoIChhdHRyaWJ1dGUpIHtcclxuICAgICAgY2FzZSBDb25zdEludGVyZmFjZS5NR19BVFRSX1RSQU5TX09XTkVSOlxyXG4gICAgICAgIHRoaXMuX3RyYW5zT3duZXIgPSB2YWx1ZTtcclxuICAgICAgICBicmVhaztcclxuXHJcbiAgICAgIGRlZmF1bHQ6XHJcbiAgICAgICAgc3VwZXIuSGFuZGxlQXR0cmlidXRlKGF0dHJpYnV0ZSwgdmFsdWUpO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgfVxyXG5cclxuICAgIC8vIFNpZ25hbCB0aGUgc2VydmVyIGhhcyBhYm9ydGVkIHRoZSB0YXNrLlxyXG4gICAgaWYgKGF0dHJpYnV0ZSA9PT0gWE1MQ29uc3RhbnRzLk1HX0FUVFJfVEFTS0lEKSB7XHJcbiAgICAgIGxldCBhYm9ydGluZ1Rhc2sgPSA8VGFzaz5BY2Nlc3NIZWxwZXIubWdEYXRhVGFibGUuR2V0VGFza0J5SUQodGhpcy5UYXNrVGFnKTtcclxuICAgICAgaWYgKGFib3J0aW5nVGFzayAhPSBudWxsKVxyXG4gICAgICAgIGFib3J0aW5nVGFzay5yZXNldEtub3duVG9TZXJ2ZXIoKTtcclxuICAgIH1cclxuICB9XHJcbn1cclxuIl19