import { AddRangeCommand } from "./AddRangeCommand";
import { RecordUtils } from "@magic-xpa/gui";
import { CommandFactory } from "../ClientToServer/CommandFactory";
import { RefParam } from "@magic-xpa/mscorelib";
import { AccessHelper } from "../../AccessHelper";
export class AddLocateCommand extends AddRangeCommand {
    async Execute(res) {
        let task = AccessHelper.mgDataTable.GetTaskByID(this.TaskTag);
        let fieldDef = task.DataView.getField(this.UserRange.veeIdx - 1);
        let parsedLen = new RefParam(0);
        let command = CommandFactory.CreateAddUserLocateDataviewCommand(this.TaskTag, this.UserRange);
        if (!this.UserRange.nullMin)
            command.Range.min = RecordUtils.deSerializeItemVal(this.UserRange.min, fieldDef.getType(), fieldDef.getSize(), true, fieldDef.getType(), parsedLen);
        if (!this.UserRange.nullMax)
            command.Range.max = RecordUtils.deSerializeItemVal(this.UserRange.max, fieldDef.getType(), fieldDef.getSize(), true, fieldDef.getType(), parsedLen);
        await task.DataviewManager.Execute(command);
    }
    constructor() {
        super();
    }
}
//# sourceMappingURL=data:application/json;base64,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