import { XmlParser } from "@magic-xpa/utils";
import { RefParam } from "@magic-xpa/mscorelib";
import { RecordUtils } from "@magic-xpa/gui";
import { ClientTargetedCommandBase } from "./ClientTargetedCommandBase";
import { CommandFactory } from "../ClientToServer/CommandFactory";
import { UserRange } from "../../tasks/TaskBase";
import { ConstInterface } from "../../ConstInterface";
import { AccessHelper } from "../../AccessHelper";
export class AddRangeCommand extends ClientTargetedCommandBase {
    constructor() {
        super();
        this.UserRange = null;
    }
    get ShouldExecute() {
        let task = AccessHelper.mgDataTable.GetTaskByID(this.TaskTag);
        return task.isStarted();
    }
    async Execute(res) {
        let task = AccessHelper.mgDataTable.GetTaskByID(this.TaskTag);
        let fieldDef = task.DataView.getField(this.UserRange.veeIdx - 1);
        let parsedLen = new RefParam(0);
        let command = CommandFactory.CreateAddUserRangeDataviewCommand(this.TaskTag, this.UserRange);
        if (!this.UserRange.nullMin)
            command.Range.min = RecordUtils.deSerializeItemVal(this.UserRange.min, fieldDef.getType(), fieldDef.getSize(), true, fieldDef.getType(), parsedLen);
        if (!this.UserRange.nullMax)
            command.Range.max = RecordUtils.deSerializeItemVal(this.UserRange.max, fieldDef.getType(), fieldDef.getSize(), true, fieldDef.getType(), parsedLen);
        await task.DataviewManager.Execute(command);
    }
    HandleAttribute(attribute, value) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_FIELD_INDEX:
                if (this.UserRange == null) {
                    this.UserRange = new UserRange();
                    this.UserRange.nullMin = this.UserRange.nullMax = this.UserRange.discardMin = this.UserRange.discardMax = true;
                }
                this.UserRange.veeIdx = XmlParser.getInt(value);
                break;
            case ConstInterface.MG_ATTR_MIN_VALUE:
                this.UserRange.min = value;
                this.UserRange.nullMin = false;
                this.UserRange.discardMin = false;
                break;
            case ConstInterface.MG_ATTR_NULL_MIN_VALUE:
                this.UserRange.nullMin = true;
                this.UserRange.discardMin = false;
                break;
            case ConstInterface.MG_ATTR_NULL_MAX_VALUE:
                this.UserRange.nullMax = true;
                this.UserRange.discardMax = false;
                break;
            case ConstInterface.MG_ATTR_MAX_VALUE:
                this.UserRange.max = value;
                this.UserRange.discardMax = false;
                this.UserRange.nullMax = false;
                break;
            default:
                super.HandleAttribute(attribute, value);
                break;
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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