import { ClientTargetedCommandBase } from "./ClientTargetedCommandBase";
import { Sort } from "../../tasks/sort/Sort";
import { CommandFactory } from "../ClientToServer/CommandFactory";
import { XmlParser } from "@magic-xpa/utils";
import { ConstInterface } from "../../ConstInterface";
import { AccessHelper } from "../../AccessHelper";
export class AddSortCommand extends ClientTargetedCommandBase {
    constructor() {
        super();
        this.UserSort = null;
    }
    async Execute(res) {
        let task = AccessHelper.mgDataTable.GetTaskByID(this.TaskTag);
        let command = CommandFactory.CreateAddUserSortDataviewCommand(this.TaskTag, this.UserSort);
        await task.DataviewManager.Execute(command);
    }
    HandleAttribute(attribute, value) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_FIELD_INDEX:
                if (this.UserSort == null)
                    this.UserSort = new Sort();
                this.UserSort.fldIdx = XmlParser.getInt(value);
                break;
            case ConstInterface.MG_ATTR_DIR:
                this.UserSort.dir = XmlParser.getInt(value) === 1 ? true : false;
                break;
            default:
                super.HandleAttribute(attribute, value);
                break;
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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