import { ClientTargetedCommandBase } from "./ClientTargetedCommandBase";
import { Debug } from "@magic-xpa/mscorelib";
import { AccessHelper } from "../../AccessHelper";
export class ClientRefreshCommand extends ClientTargetedCommandBase {
    constructor() {
        super();
    }
    async Execute(res) {
        let task = AccessHelper.mgDataTable.GetTaskByID(this.TaskTag);
        Debug.Assert(task.IsSubForm);
        if (ClientRefreshCommand.ClientIsInRollbackCommand)
            return;
        if (task.AfterFirstRecordPrefix && !task.InEndTask) {
            if ((task.DataView.getCurrRec()).InRecompute)
                task.ExecuteClientSubformRefresh = true;
            else {
                task.PerformParentRecordPrefix = false;
                await task.getParent().SubformRefresh(task, true);
                task.PerformParentRecordPrefix = true;
            }
        }
    }
}
ClientRefreshCommand.ClientIsInRollbackCommand = false;
//# sourceMappingURL=data:application/json;base64,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