import { VerifyCommand } from "./VerifyCommand";
import { Operation } from "../../rt/Operation";
import { Task } from "../../tasks/Task";
import { ConstInterface } from "../../ConstInterface";
import { LanguageData } from "../../env/LanguageData";
export class EnhancedVerifyCommand extends VerifyCommand {
    async ProcessMessageBoxResponse(task, returnValue) {
        if (task !== null)
            await Operation.setoperVerifyReturnValue(returnValue, this._returnVal);
    }
    PrepareMessageBoxForDisplay(task, mlsTransTitle, style) {
        mlsTransTitle.value = LanguageData.Instance.translate(this._title);
        style.value = Operation.getButtons(this._buttonsID);
        style.value |= Operation.getImage(this._image);
        if (task !== null) {
            if (Task.isMainProgramField(this._returnValStr)) {
                this._returnVal = Operation.InitField(this._returnValStr, task);
            }
        }
    }
    HandleAttribute(attribute, value) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_IMAGE:
                this._image = value[0];
                break;
            case ConstInterface.MG_ATTR_BUTTONS:
                this._buttonsID = value[0];
                break;
            case ConstInterface.MG_ATTR_RETURN_VAL:
                this._returnValStr = value;
                break;
            default:
                super.HandleAttribute(attribute, value);
                break;
        }
    }
    constructor() {
        super();
        this._buttonsID = '\0';
        this._image = '\0';
        this._returnValStr = null;
        this._returnVal = null;
    }
}
//# sourceMappingURL=data:application/json;base64,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