import { Debug, Int32, List, NString } from "@magic-xpa/mscorelib";
import { InternalInterface, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { ClientTargetedCommandBase } from "./ClientTargetedCommandBase";
import { ArgumentsList } from "../../rt/ArgumentsList";
import { MGData } from "../../tasks/MGData";
import { MgControl } from "../../gui/MgControl";
import { OpeningTaskDetails } from "../../tasks/TaskBase";
import { ConstInterface } from "../../ConstInterface";
import { LastFocusedManager } from "../../rt/LastFocusedManager";
import { RemoteCommandsProcessor } from "../../remote/RemoteCommandsProcessor";
import { Task } from "../../tasks/Task";
import { AccessHelper } from "../../AccessHelper";
import { MgControlType } from "@magic-xpa/utils";
import { RunTimeEvent } from '../../event/RunTimeEvent';
export class OpenURLCommand extends ClientTargetedCommandBase {
    constructor() {
        super();
        this._callingTaskTag = null;
        this._pathParentTaskTag = null;
        this._subformCtrlName = null;
        this._ditIdx = Int32.MinValue;
        this._isModal = true;
        this._transOwner = null;
        this._newId = null;
        this._forceModal = false;
        this._key = null;
        this._varList = null;
        this._isRoute = false;
        this.NewTaskXML = null;
    }
    get IsBlocking() {
        return this._isModal && this._subformCtrlName === null;
    }
    async Execute(res) {
        let mgd = null;
        let destinationSubformSucceeded = false;
        let refreshWhenHidden = true;
        let mgdID = 0;
        let subformCtrl = null;
        let oldTimers = new List(), newTimers = new List();
        let moveToFirstControl = true;
        let guiParentTask;
        let guiParentMgData = null;
        let callingTask = (this._callingTaskTag != null ? AccessHelper.mgDataTable.GetTaskByID(this._callingTaskTag) : null);
        let pathParentTask = (this._pathParentTaskTag != null ? AccessHelper.mgDataTable.GetTaskByID(this._pathParentTaskTag) : null);
        guiParentTask = callingTask = AccessHelper.mgDataTable.GetTaskByID(this._callingTaskTag);
        if ((!NString.IsNullOrEmpty(this._subformCtrlName)) || (this._ditIdx !== Int32.MinValue) || this._isRoute) {
            if (this._isRoute && NString.IsNullOrEmpty(this._subformCtrlName.trim())) {
                subformCtrl = callingTask.getForm().DefaultRouterOutlet;
            }
            else {
                if (!callingTask.IsInteractive) {
                    for (let parentTask = callingTask; parentTask.getForm() != null; parentTask = parentTask.getParent()) {
                        subformCtrl = parentTask.getForm().getCtrlByName(this._subformCtrlName, MgControlType.CTRL_TYPE_SUBFORM);
                        if (subformCtrl != null) {
                            callingTask = guiParentTask = parentTask;
                            break;
                        }
                    }
                }
                else
                    subformCtrl = (this._ditIdx !== Int32.MinValue ? callingTask.getForm().getCtrl(this._ditIdx) : callingTask.getForm().getSubFormCtrlByName(this._subformCtrlName));
            }
        }
        if (callingTask != null)
            mgd = callingTask.getMGData();
        if (subformCtrl != null) {
            let subformTask = subformCtrl.getSubformTask();
            guiParentTask = subformCtrl.getForm().getTask();
            mgdID = guiParentTask.getMgdID();
            guiParentMgData = guiParentTask.getMGData();
            if (guiParentMgData.getTimerHandlers() != null)
                oldTimers = guiParentMgData.getTimerHandlers().getTimersVector();
            if (this._ditIdx !== Int32.MinValue) {
                refreshWhenHidden = false;
                moveToFirstControl = false;
            }
            else {
                destinationSubformSucceeded = true;
                if (this._transOwner != null) {
                    let newTransOwnerTask = AccessHelper.mgDataTable.GetTaskByID(this._transOwner);
                    if (newTransOwnerTask != null)
                        newTransOwnerTask.setTransOwnerTask();
                }
                if (subformTask != null) {
                    subformTask.setDestinationSubform(true);
                    await subformTask.stop();
                }
                if (!MgControl.validReturnToCtrl())
                    MgControl.ReturnToCtrl = LastFocusedManager.getLastFocusedControl();
            }
            subformCtrl.setSubformTaskId(this._newId);
        }
        let parentMgData;
        if (callingTask == null)
            parentMgData = AccessHelper.mgDataTable.getMGData(0);
        else
            parentMgData = callingTask.getMGData();
        if (!destinationSubformSucceeded && refreshWhenHidden) {
            mgdID = AccessHelper.mgDataTable.getAvailableIdx();
            Debug.Assert(mgdID > 0);
            mgd = new MGData(OpenURLCommand.createNewCommandsTable(), OpenURLCommand.createNewCommandsTable(), mgdID, parentMgData, this._isModal, this._forceModal);
            mgd.copyUnframedCmds();
            await AccessHelper.mgDataTable.addMGData(mgd, mgdID, false);
            AccessHelper.mgDataTable.currMgdID = mgdID;
        }
        this.Obj = this._key;
        this._key = null;
        try {
            await RemoteCommandsProcessor.GetInstance().ProcessResponse(this.NewTaskXML, mgdID, new OpeningTaskDetails(callingTask, pathParentTask), null);
        }
        finally {
            AccessHelper.eventsManager.setIgnoreUnknownAbort(false);
        }
        if (destinationSubformSucceeded || !refreshWhenHidden) {
            subformCtrl.initSubformTask();
            if (destinationSubformSucceeded) {
                let subformTask = subformCtrl.getSubformTask();
                moveToFirstControl = !callingTask.RetainFocus;
                subformTask.setIsDestinationCall(true);
            }
        }
        let isSubformModal = false;
        let prevMgDataIsModal = mgd.IsModal;
        if (subformCtrl != null) {
            if (guiParentMgData.getTimerHandlers() != null)
                newTimers = guiParentMgData.getTimerHandlers().getTimersVector();
            guiParentMgData.changeTimers(oldTimers, newTimers);
            if (subformCtrl.IsModal())
                this._isModal = isSubformModal = mgd.IsModal = true;
        }
        let nonInteractiveTask = await Task.StartProgram(destinationSubformSucceeded, moveToFirstControl);
        if (!isSubformModal)
            this._isModal = mgd.IsModal;
        if (nonInteractiveTask == null) {
            if (callingTask != null && ((this._isModal && (isSubformModal || !destinationSubformSucceeded) && refreshWhenHidden) || (!callingTask.IsInteractive && (!callingTask.isMainProg() || callingTask.getForm() == null)))) {
                if (this._isModal) {
                    AccessHelper.mgDataTable.startTasksIteration();
                    let task;
                    while ((task = AccessHelper.mgDataTable.getNextTask()) !== null) {
                        let dataViewWasRetrieved = task.DataViewWasRetrieved;
                        if (dataViewWasRetrieved) {
                            await task.RefreshDisplay();
                        }
                    }
                }
                await AccessHelper.eventsManager.EventsLoop(mgd);
                if (isSubformModal) {
                    mgd.IsAborting = false;
                    mgd.IsModal = prevMgDataIsModal;
                }
            }
        }
        else
            await AccessHelper.eventsManager.NonInteractiveEventsLoop(mgd, nonInteractiveTask);
        if (AccessHelper.eventsManager.getPendingGuiEvent() != null && (isSubformModal || nonInteractiveTask != null)) {
            let guiEvent = AccessHelper.eventsManager.getPendingGuiEvent();
            if (guiEvent.getTask() != callingTask || this._callingTaskTag !== callingTask.getTaskTag()) {
                callingTask = AccessHelper.mgDataTable.GetTaskByID(this._callingTaskTag);
                if (callingTask.getIsDestinationCall()) {
                    let subformCtrl = callingTask.getForm().getSubFormCtrl();
                    await AccessHelper.eventsManager.performSubformClose(subformCtrl);
                }
                else {
                    let rtEvt = new RunTimeEvent(callingTask);
                    rtEvt.setInternal(InternalInterface.MG_ACT_CLOSE);
                    rtEvt.setCtrl(null);
                    rtEvt.setArgList(null);
                    AccessHelper.eventsManager.addToTail(rtEvt);
                }
            }
            else {
                AccessHelper.eventsManager.addToTail(guiEvent);
                AccessHelper.eventsManager.setPendingGuiEvent(null);
            }
        }
    }
    HandleAttribute(attribute, value) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_CALLINGTASK:
                this._callingTaskTag = value;
                break;
            case ConstInterface.MG_ATTR_PATH_PARENT_TASK:
                this._pathParentTaskTag = value;
                break;
            case ConstInterface.MG_ATTR_SUBFORM_CTRL:
                this._subformCtrlName = value;
                break;
            case XMLConstants.MG_ATTR_DITIDX:
                this._ditIdx = XmlParser.getInt(value);
                break;
            case ConstInterface.MG_ATTR_MODAL:
                this._isModal = (value[0] === '1');
                break;
            case ConstInterface.MG_ATTR_TRANS_OWNER:
                this._transOwner = value;
                break;
            case ConstInterface.MG_ATTR_NEWID:
                this._newId = NString.TrimEnd(value);
                break;
            case ConstInterface.MG_ATTR_KEY:
                this._key = value;
                break;
            case ConstInterface.MG_ATTR_ARGLIST:
                this._varList = new ArgumentsList();
                this._varList.fillList(value, AccessHelper.mgDataTable.GetTaskByID(this.TaskTag));
                break;
            case ConstInterface.MG_ATTR_OBJECT:
                this.Obj = value;
                break;
            case ConstInterface.MG_ATTR_IS_ROUTE:
                this._isRoute = (value[0] === '1');
                break;
            default:
                super.HandleAttribute(attribute, value);
                break;
        }
    }
}
OpenURLCommand.createNewCommandsTable = null;
//# sourceMappingURL=data:application/json;base64,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