import { ClientTargetedCommandBase } from "./ClientTargetedCommandBase";
import { StorageAttribute, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { ConstInterface } from "../../ConstInterface";
export class ResultCommand extends ClientTargetedCommandBase {
    async Execute(res) {
        if (this._isNull)
            res.SetResultValue(null, StorageAttribute.NONE);
        else {
            if (this._val == null)
                this._val = "";
            res.SetResultValue(this._val, this._attr);
        }
    }
    HandleAttribute(attribute, value) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_NULL:
                this._isNull = (XmlParser.getInt(value) === 1);
                break;
            case ConstInterface.MG_ATTR_PAR_ATTRS:
                this._attr = value[0];
                break;
            case XMLConstants.MG_ATTR_VALUE:
                this._val = XmlParser.unescape(value);
                break;
            default:
                super.HandleAttribute(attribute, value);
                break;
        }
    }
    constructor() {
        super();
        this._isNull = false;
        this._attr = StorageAttribute.NONE;
        this._val = null;
    }
}
//# sourceMappingURL=data:application/json;base64,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