import { ClientTargetedCommandBase } from './ClientTargetedCommandBase';
import { NString, RefParam } from '@magic-xpa/mscorelib';
import { Styles } from '@magic-xpa/gui';
import { Logger, MsgInterface, StrUtil, XmlParser } from '@magic-xpa/utils';
import { ConstUtils } from '../../util/ConstUtils';
import { ConstInterface } from '../../ConstInterface';
import { LanguageData } from '../../env/LanguageData';
import { LastFocusedManager } from '../../rt/LastFocusedManager';
import { AccessHelper } from '../../AccessHelper';
import { GUIManager } from "../../GUIManager";
export class VerifyCommand extends ClientTargetedCommandBase {
    constructor() {
        super();
        this._callingTaskTag = null;
        this._title = null;
        this._errLogAppend = false;
        this._text = null;
        this._display = '\0';
        this._mode = '\0';
    }
    async Execute(res) {
        let errForConsole = StrUtil.getConsoleErorString(this._text);
        let task = (AccessHelper.mgDataTable.GetTaskByID(this.TaskTag) || AccessHelper.mgDataTable.GetTaskByID(this._callingTaskTag));
        if (task === null)
            task = LastFocusedManager.Instance.getLastFocusedTask();
        let errLogAppend = this._errLogAppend;
        if (errLogAppend)
            Logger.Instance.WriteExceptionToLogWithMsg(errForConsole);
        if (!NString.IsNullOrEmpty(this._text)) {
            if (this._display === ConstInterface.DISPLAY_BOX) {
                let style = new RefParam(0);
                let errForMsgBox = StrUtil.getMsgBoxErorString(this._text);
                let mlsTransText = LanguageData.Instance.translate(errForMsgBox);
                let mlsTransTitle = new RefParam(NString.Empty);
                this.PrepareMessageBoxForDisplay(task, mlsTransTitle, style);
                let returnValue = await GUIManager.Instance.MessageBox(mlsTransTitle.value, mlsTransText, style.value);
                await this.ProcessMessageBoxResponse(task, returnValue);
            }
            else if (this._display === ConstInterface.DISPLAY_STATUS && task != null) {
                task.DisplayMessageToStatusBar(errForConsole);
            }
        }
    }
    PrepareMessageBoxForDisplay(task, mlsTransTitle, style) {
        let options = LanguageData.Instance.getConstMessage(MsgInterface.BRKTAB_STOP_MODE_TITLE);
        this._title = ConstUtils.getStringOfOption(options, "EW", this._mode);
        mlsTransTitle.value = LanguageData.Instance.translate(this._title);
        style.value = Styles.MSGBOX_BUTTON_OK |
            ((this._mode === 'E')
                ? Styles.MSGBOX_ICON_ERROR
                : Styles.MSGBOX_ICON_WARNING);
    }
    ProcessMessageBoxResponse(task, returnValue) {
    }
    HandleAttribute(attribute, value) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_TITLE:
                this._title = value;
                break;
            case ConstInterface.MG_ATTR_CALLINGTASK:
                this._callingTaskTag = value;
                break;
            case ConstInterface.MG_ATTR_ERR_LOG_APPEND:
                this._errLogAppend = XmlParser.getBoolean(value);
                break;
            case ConstInterface.MG_ATTR_TEXT:
                this._text = XmlParser.unescape(value);
                break;
            case ConstInterface.MG_ATTR_DISPLAY:
                this._display = value[0];
                break;
            case ConstInterface.MG_ATTR_MODE:
                this._mode = value[0];
                break;
            case ConstInterface.MG_ATTR_ACK:
                break;
            default:
                super.HandleAttribute(attribute, value);
                break;
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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