import { OSEnvironment } from "@magic-xpa/utils";
import { Styles } from "@magic-xpa/gui";
import { GUIManager } from "../GUIManager";
export class InteractiveCommunicationsFailureHandler {
    constructor() {
        this.ShouldRetryLastRequest = false;
    }
    get ShowCommunicationErrors() {
        return true;
    }
    async CommunicationFailed(url, ex) {
        let exceptionCaption = "";
        let exceptionMessage = url.split('?')[0] + OSEnvironment.EolSeq + OSEnvironment.EolSeq + ex.message + OSEnvironment.EolSeq + OSEnvironment.EolSeq;
        this.ShouldRetryLastRequest = (await GUIManager.Instance.MessageBox(exceptionCaption, exceptionMessage + "Do you wish to retry connecting?", Styles.MSGBOX_BUTTON_YES_NO) === Styles.MSGBOX_RESULT_YES);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSW50ZXJhY3RpdmVDb21tdW5pY2F0aW9uc0ZhaWx1cmVIYW5kbGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy9jb21tdW5pY2F0aW9ucy9JbnRlcmFjdGl2ZUNvbW11bmljYXRpb25zRmFpbHVyZUhhbmRsZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFDLGFBQWEsRUFBQyxNQUFNLGtCQUFrQixDQUFDO0FBQy9DLE9BQU8sRUFBQyxNQUFNLEVBQUMsTUFBTSxnQkFBZ0IsQ0FBQztBQUV0QyxPQUFPLEVBQUMsVUFBVSxFQUFDLE1BQU0sZUFBZSxDQUFDO0FBT3pDLE1BQU0sT0FBTyx1Q0FBdUM7SUFBcEQ7UUFDRSwyQkFBc0IsR0FBWSxLQUFLLENBQUM7SUF1QjFDLENBQUM7SUFyQkMsSUFBSSx1QkFBdUI7UUFDekIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRU0sS0FBSyxDQUFDLG1CQUFtQixDQUFDLEdBQVcsRUFBRSxFQUFTO1FBRXJELElBQUksZ0JBQWdCLEdBQVcsRUFBRSxDQUFDO1FBUWxDLElBQUksZ0JBQWdCLEdBQVcsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxhQUFhLENBQUMsTUFBTSxHQUFHLGFBQWEsQ0FBQyxNQUFNLEdBQUcsRUFBRSxDQUFDLE9BQU8sR0FBRyxhQUFhLENBQUMsTUFBTSxHQUFHLGFBQWEsQ0FBQyxNQUFNLENBQUM7UUFFMUosSUFBSSxDQUFDLHNCQUFzQixHQUFHLENBQUMsTUFBTSxVQUFVLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsRUFDbEYsZ0JBQWdCLEdBQUcsa0NBQWtDLEVBQ3JELE1BQU0sQ0FBQyxvQkFBb0IsQ0FBRSxLQUFLLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7Q0FFRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7T1NFbnZpcm9ubWVudH0gZnJvbSBcIkBtYWdpYy14cGEvdXRpbHNcIjtcclxuaW1wb3J0IHtTdHlsZXN9IGZyb20gXCJAbWFnaWMteHBhL2d1aVwiO1xyXG5pbXBvcnQge0lDb21tdW5pY2F0aW9uc0ZhaWx1cmVIYW5kbGVyfSBmcm9tIFwiLi4vaHR0cC9jbGllbnQvSUNvbW11bmljYXRpb25zRmFpbHVyZUhhbmRsZXJcIjtcclxuaW1wb3J0IHtHVUlNYW5hZ2VyfSBmcm9tIFwiLi4vR1VJTWFuYWdlclwiO1xyXG5cclxuLy8vIDxzdW1tYXJ5PlxyXG4vLy8gVGhpcyBpcyB0aGUgaGFuZGxlciBmb3IgY29tbXVuaWNhdGlvbnMgdGhhdCB3aWxsIGJlIHVzZWQgaW4gbW9zdCBjYXNlcy4gVGhpc1xyXG4vLy8gaW1wbGVtZW50YXRpb24gc2hvd3MgYSBkaWFsb2cgdGhhdCBhc2tzIHRoZSB1c2VyIHdoZXRoZXIgdG8gcmV0cnkgdGhlIGxhc3RcclxuLy8vIGNvbW11bmljYXRpb25zIGF0dGVtcHQgb3Igbm90IGFuZCBzZXRzIHRoZSBTaG91bGRSZXRyeUxhc3RSZXF1ZXN0IGFjY29yZGluZ2x5LlxyXG4vLy8gPC9zdW1tYXJ5PlxyXG5leHBvcnQgY2xhc3MgSW50ZXJhY3RpdmVDb21tdW5pY2F0aW9uc0ZhaWx1cmVIYW5kbGVyIGltcGxlbWVudHMgSUNvbW11bmljYXRpb25zRmFpbHVyZUhhbmRsZXIge1xyXG4gIFNob3VsZFJldHJ5TGFzdFJlcXVlc3Q6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgZ2V0IFNob3dDb21tdW5pY2F0aW9uRXJyb3JzKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRydWU7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgYXN5bmMgQ29tbXVuaWNhdGlvbkZhaWxlZCh1cmw6IHN0cmluZywgZXg6IEVycm9yKTogUHJvbWlzZTx2b2lkPiB7XHJcblxyXG4gICAgbGV0IGV4Y2VwdGlvbkNhcHRpb246IHN0cmluZyA9IFwiXCI7XHJcbiAgICAvLyBUT0RPIDogRmluZCBvdXQgaG93IHRvIGdldCBjYXB0aW9uXHJcbiAgICAvLyBsZXQgZXhjZXB0aW9uQ2FwdGlvbjogc3RyaW5nID0gTlN0cmluZy5Gb3JtYXQoXCJ7MH0gezF9XCIsXHJcbiAgICAvLyAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBEYXRlVGltZVV0aWxzLlRvU3RyaW5nKERhdGVUaW1lLk5vdyxcclxuICAgIC8vICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgWE1MQ29uc3RhbnRzLkhUVFBfRVJST1JfVElNRV9GT1JNQVQpLFxyXG4gICAgLy8gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKGV4LklubmVyRXhjZXB0aW9uICE9IG51bGwgPyBleC5Jbm5lckV4Y2VwdGlvbi5HZXRUeXBlKCkgOiBleC5HZXRUeXBlKCkpLk5hbWUpO1xyXG5cclxuXHJcbiAgICBsZXQgZXhjZXB0aW9uTWVzc2FnZTogc3RyaW5nID0gdXJsLnNwbGl0KCc/JylbMF0gKyBPU0Vudmlyb25tZW50LkVvbFNlcSArIE9TRW52aXJvbm1lbnQuRW9sU2VxICsgZXgubWVzc2FnZSArIE9TRW52aXJvbm1lbnQuRW9sU2VxICsgT1NFbnZpcm9ubWVudC5Fb2xTZXE7XHJcblxyXG4gICAgdGhpcy5TaG91bGRSZXRyeUxhc3RSZXF1ZXN0ID0gKGF3YWl0IEdVSU1hbmFnZXIuSW5zdGFuY2UuTWVzc2FnZUJveChleGNlcHRpb25DYXB0aW9uLFxyXG4gICAgICBleGNlcHRpb25NZXNzYWdlICsgXCJEbyB5b3Ugd2lzaCB0byByZXRyeSBjb25uZWN0aW5nP1wiLFxyXG4gICAgICBTdHlsZXMuTVNHQk9YX0JVVFRPTl9ZRVNfTk8gKSA9PT0gU3R5bGVzLk1TR0JPWF9SRVNVTFRfWUVTKTtcclxuICB9XHJcblxyXG59XHJcbiJdfQ==