import { DataviewManagerBase } from "./DataviewManagerBase";
import { RemoteDataviewManager } from "../remote/RemoteDataviewManager";
export class DataviewManager extends DataviewManagerBase {
    get TaskService() {
        return this.Task.TaskService;
    }
    get CurrentDataviewManager() {
        let result;
        if (this.HasRemoteData)
            result = this.RemoteDataviewManager;
        else
            result = this.VirtualDataviewManager;
        return result;
    }
    get VirtualDataviewManager() {
        return this.TaskService.GetDataviewManagerForVirtuals(this.Task);
    }
    constructor(task) {
        super(task);
        this.RemoteDataviewManager = null;
        this.HasRemoteData = true;
        this.RemoteDataviewManager = new RemoteDataviewManager(task);
    }
    async Execute(command) {
        return await this.CurrentDataviewManager.Execute(command);
    }
}
//# sourceMappingURL=data:application/json;base64,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