import { Hashtable, List } from '@magic-xpa/mscorelib';
export class DvCache {
    constructor(tsk) {
        this._cacheTable = null;
        this._deletedList = null;
        this._task = null;
        this._task = tsk;
        this._cacheTable = new Hashtable(100, 0.7);
        this._deletedList = new List();
    }
    putInCache(repOfOriginal) {
        let hashKey = repOfOriginal.getDvPosValue();
        if (this._cacheTable.get_Item(hashKey) !== null)
            this.removeDvFromCache(hashKey, false);
        repOfOriginal.setCacheLRU();
        repOfOriginal.taskModeFromCache = this._task.getMode();
        repOfOriginal.zeroServerCurrRec();
        this._cacheTable.set_Item(hashKey, repOfOriginal);
        this._deletedList.Remove(hashKey);
        return true;
    }
    removeDvFromCache(DvPosValue, updateDel) {
        let rep = this._cacheTable.get_Item(DvPosValue);
        if (rep !== null) {
            if (updateDel)
                this._deletedList.push(DvPosValue);
            this._cacheTable.Remove(DvPosValue);
            return true;
        }
        return false;
    }
    getDeletedListToXML() {
        let list = '';
        for (let i = 0; i < this._deletedList.length; i++) {
            if (i > 0)
                list = list + ',';
            list += this._deletedList.get_Item(i).toString();
        }
        return list;
    }
    clearDeletedList() {
        this._deletedList.Clear();
    }
    getCachedDataView(DvPosValue) {
        let cached = this._cacheTable.get_Item(DvPosValue);
        if (cached !== null)
            cached = cached.replicate();
        return cached;
    }
    clearCache() {
        let dvKeysList = new List(this._cacheTable.Keys);
        for (let i = 0; i < dvKeysList.length; i++) {
            let dvKey = dvKeysList[i];
            this.removeDvFromCache(dvKey, true);
        }
        if (this._task.hasSubTasks()) {
            let subTasks = this._task.getSubTasks();
            for (let j = 0; j < subTasks.getSize(); j = j + 1)
                subTasks.getTask(j).getTaskCache().clearCache();
        }
        this._task.DataView.setChanged(true);
    }
    isDeleted(dvPosVal) {
        return this._deletedList.Contains(dvPosVal);
    }
}
//# sourceMappingURL=data:application/json;base64,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