import { List } from "@magic-xpa/mscorelib";
import { XMLConstants, Logger } from "@magic-xpa/utils";
import { FieldDef, FieldsTable as FieldsTableBase } from "@magic-xpa/gui";
import { Field } from "./Field";
class FieldsTable extends FieldsTableBase {
    constructor() {
        super();
        this._rmIdx = 0;
        this._rmSize = -1;
        this._serverRcmpDone = false;
    }
    fillData(parser, dataview) {
        if (arguments.length === 2)
            super.fillData(parser, dataview);
        else {
            while (this.initFields(parser.getNextTag(), parser)) {
            }
        }
    }
    initFields(foundTagName, parser) {
        if (foundTagName == null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_FLDH) {
            let item = this.initField(parser);
            this._fields.push(item);
        }
        else {
            return false;
        }
        return true;
    }
    initField(parser, dataview) {
        if (arguments.length === 2)
            return this.initField_0(dataview, parser);
        else
            return this.initField_1(parser);
    }
    initField_0(dataview, parser) {
        let field = new Field(dataview, this._fields.length);
        field.fillData(parser);
        return field;
    }
    initField_1(parser) {
        let fieldDef = new FieldDef(this._fields.length);
        fieldDef.fillData(parser);
        return fieldDef;
    }
    getRMSize() {
        if (this._rmSize === -1)
            return this._fields.length;
        return this._rmSize;
    }
    getRMIdx() {
        return this._rmIdx;
    }
    setRMPos(rms, idx) {
        if (rms < 0 && this._rmSize !== -1) {
            Logger.Instance.WriteExceptionToLogWithMsg("in FieldsTable.setRMSize(): illegal record main size: " + rms);
        }
        else if (this._rmSize >= 0) {
            Logger.Instance.WriteExceptionToLogWithMsg("in FieldsTable.setRMSize(): record main size already set !");
        }
        else {
            this._rmSize = rms;
            this._rmIdx = idx;
        }
    }
    getType(id) {
        return super.getField(id).getType();
    }
    invalidate(forceInvalidate, clearFlags) {
        for (let i = 0; i < this._fields.length; i++) {
            let currField = this._fields[i];
            currField.invalidate(forceInvalidate, clearFlags);
        }
    }
    takeValsFromRec() {
        for (let i = 0; i < this._fields.length; i++) {
            let currField = this._fields[i];
            currField.takeValFromRec();
        }
    }
    serverRcmpDone() {
        return this._serverRcmpDone;
    }
    setServerRcmp(val) {
        this._serverRcmpDone = val;
    }
    getLinkFields(lnkId) {
        let list = new List();
        this._fields.forEach(field => {
            if (field.getDataviewHeaderId() === lnkId) {
                list.push(field);
            }
        });
        return list;
    }
    resetRecomp() {
        this._fields.forEach(field => field.setRecompute(null));
    }
}
export { FieldsTable as FieldsTableExt };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRmllbGRzVGFibGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9lbmdpbmUvc3JjL2RhdGEvRmllbGRzVGFibGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBR0EsT0FBTyxFQUFDLElBQUksRUFBQyxNQUFNLHNCQUFzQixDQUFDO0FBQzFDLE9BQU8sRUFBQyxZQUFZLEVBQW9CLE1BQU0sRUFBWSxNQUFNLGtCQUFrQixDQUFDO0FBQ25GLE9BQU8sRUFBQyxRQUFRLEVBQW1CLFdBQVcsSUFBSSxlQUFlLEVBQUMsTUFBTSxnQkFBZ0IsQ0FBQztBQUN6RixPQUFPLEVBQUMsS0FBSyxFQUFDLE1BQU0sU0FBUyxDQUFDO0FBRzdCLE1BQU0sV0FBYSxTQUFRLGVBQWU7SUFLekM7UUFDRSxLQUFLLEVBQUUsQ0FBQztRQUxGLFdBQU0sR0FBVyxDQUFDLENBQUM7UUFDbkIsWUFBTyxHQUFXLENBQUMsQ0FBQyxDQUFDO1FBQ3JCLG9CQUFlLEdBQVksS0FBSyxDQUFDO0lBSXpDLENBQUM7SUFJRCxRQUFRLENBQUMsTUFBaUIsRUFBRSxRQUEwQjtRQUNwRCxJQUFJLFNBQVMsQ0FBQyxNQUFNLEtBQUssQ0FBQztZQUN4QixLQUFLLENBQUMsUUFBUSxDQUFDLE1BQU0sRUFBRSxRQUFRLENBQUMsQ0FBQzthQUM5QjtZQUNILE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsVUFBVSxFQUFFLEVBQUUsTUFBTSxDQUFDLEVBQUU7YUFDcEQ7U0FDRjtJQUNILENBQUM7SUFLTyxVQUFVLENBQUMsWUFBb0IsRUFBRSxNQUFpQjtRQUN4RCxJQUFJLFlBQVksSUFBSSxJQUFJO1lBQ3RCLE9BQU8sS0FBSyxDQUFDO1FBRWYsSUFBSSxZQUFZLEtBQUssWUFBWSxDQUFDLFdBQVcsRUFBRTtZQUM3QyxJQUFJLElBQUksR0FBYSxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQzVDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1NBQ3pCO2FBQ0k7WUFFSCxPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBSUQsU0FBUyxDQUFDLE1BQWlCLEVBQUUsUUFBMEI7UUFDckQsSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUM7WUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsRUFBRSxNQUFNLENBQUMsQ0FBQzs7WUFFMUMsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFPTyxXQUFXLENBQUMsUUFBeUIsRUFBRSxNQUFpQjtRQUM5RCxJQUFJLEtBQUssR0FBVSxJQUFJLEtBQUssQ0FBVyxRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN0RSxLQUFLLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZCLE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQU1PLFdBQVcsQ0FBQyxNQUFpQjtRQUNuQyxJQUFJLFFBQVEsR0FBYSxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzNELFFBQVEsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDMUIsT0FBTyxRQUFRLENBQUM7SUFDbEIsQ0FBQztJQUtELFNBQVM7UUFDUCxJQUFJLElBQUksQ0FBQyxPQUFPLEtBQUssQ0FBQyxDQUFDO1lBQ3JCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUM7UUFDN0IsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFLRCxRQUFRO1FBQ04sT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFPRCxRQUFRLENBQUMsR0FBVyxFQUFFLEdBQVc7UUFDL0IsSUFBSSxHQUFHLEdBQUcsQ0FBQyxJQUFJLElBQUksQ0FBQyxPQUFPLEtBQUssQ0FBQyxDQUFDLEVBQUU7WUFDbEMsTUFBTSxDQUFDLFFBQVEsQ0FBQywwQkFBMEIsQ0FBQyx3REFBd0QsR0FBRyxHQUFHLENBQUMsQ0FBQztTQUM1RzthQUNJLElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLEVBQUU7WUFDMUIsTUFBTSxDQUFDLFFBQVEsQ0FBQywwQkFBMEIsQ0FBQyw0REFBNEQsQ0FBQyxDQUFDO1NBQzFHO2FBQ0k7WUFDSCxJQUFJLENBQUMsT0FBTyxHQUFHLEdBQUcsQ0FBQztZQUNuQixJQUFJLENBQUMsTUFBTSxHQUFHLEdBQUcsQ0FBQztTQUNuQjtJQUNILENBQUM7SUFRRCxPQUFPLENBQUMsRUFBVTtRQUNoQixPQUFPLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDdEMsQ0FBQztJQU9ELFVBQVUsQ0FBQyxlQUF3QixFQUFFLFVBQW1CO1FBQ3RELEtBQUksSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFHLENBQUMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRyxDQUFDLEVBQUUsRUFDN0M7WUFDRSxJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3hCLFNBQVUsQ0FBQyxVQUFVLENBQUMsZUFBZSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1NBQzVEO0lBQ0gsQ0FBQztJQUtELGVBQWU7UUFDYixLQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRyxDQUFDLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUcsQ0FBQyxFQUFFLEVBQUU7WUFDN0MsSUFBSSxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUN4QixTQUFVLENBQUMsY0FBYyxFQUFFLENBQUE7U0FDcEM7SUFDSCxDQUFDO0lBS0QsY0FBYztRQUNaLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBTUQsYUFBYSxDQUFDLEdBQVk7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxHQUFHLENBQUM7SUFDN0IsQ0FBQztJQU1ELGFBQWEsQ0FBQyxLQUFhO1FBQ3pCLElBQUksSUFBSSxHQUFnQixJQUFJLElBQUksRUFBUyxDQUFDO1FBRTFDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQzNCLElBQVksS0FBTSxDQUFDLG1CQUFtQixFQUFFLEtBQUssS0FBSyxFQUFFO2dCQUNsRCxJQUFJLENBQUMsSUFBSSxDQUFRLEtBQUssQ0FBQyxDQUFDO2FBQ3pCO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFNRCxXQUFXO1FBQ1QsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBUyxLQUFNLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkUsQ0FBQztDQUNGO0FBRUQsT0FBUSxFQUFDLFdBQVcsSUFBSSxjQUFjLEVBQUUsQ0FBQSIsInNvdXJjZXNDb250ZW50IjpbIi8vLyA8c3VtbWFyeT5cclxuLy8vICAgZGF0YSBmb3IgPGR2aGVhZGVyIC4uLj4uLi48L2R2aGVhZGVyPlxyXG4vLy8gPC9zdW1tYXJ5PlxyXG5pbXBvcnQge0xpc3R9IGZyb20gXCJAbWFnaWMteHBhL21zY29yZWxpYlwiO1xyXG5pbXBvcnQge1hNTENvbnN0YW50cywgU3RvcmFnZUF0dHJpYnV0ZSwgTG9nZ2VyLCBYbWxQYXJzZXJ9IGZyb20gXCJAbWFnaWMteHBhL3V0aWxzXCI7XHJcbmltcG9ydCB7RmllbGREZWYsIEd1aURhdGFWaWV3QmFzZSwgRmllbGRzVGFibGUgYXMgRmllbGRzVGFibGVCYXNlfSBmcm9tIFwiQG1hZ2ljLXhwYS9ndWlcIjtcclxuaW1wb3J0IHtGaWVsZH0gZnJvbSBcIi4vRmllbGRcIjtcclxuaW1wb3J0IHtEYXRhVmlld30gZnJvbSBcIi4vRGF0YVZpZXdcIjtcclxuXHJcbiBjbGFzcyBGaWVsZHNUYWJsZSAgZXh0ZW5kcyBGaWVsZHNUYWJsZUJhc2Uge1xyXG4gIHByaXZhdGUgX3JtSWR4OiBudW1iZXIgPSAwO1xyXG4gIHByaXZhdGUgX3JtU2l6ZTogbnVtYmVyID0gLTE7XHJcbiAgcHJpdmF0ZSBfc2VydmVyUmNtcERvbmU6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgY29uc3RydWN0b3IoKXtcclxuICAgIHN1cGVyKCk7XHJcbiAgfVxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBhIGRpZmZlcmVudCB2ZXJzaW9uIG9mIGZpbGwgZGF0YSBpbiBvcmRlciB0byBiZSB1c2VkIGluIHRhYmxlIGNhY2hlXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBmaWxsRGF0YShwYXJzZXI6IFhtbFBhcnNlciwgZGF0YXZpZXc/OiBHdWlEYXRhVmlld0Jhc2UpOiB2b2lkIHtcclxuICAgIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAyKVxyXG4gICAgICBzdXBlci5maWxsRGF0YShwYXJzZXIsIGRhdGF2aWV3KTtcclxuICAgIGVsc2Uge1xyXG4gICAgICB3aGlsZSAodGhpcy5pbml0RmllbGRzKHBhcnNlci5nZXROZXh0VGFnKCksIHBhcnNlcikpIHtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5Pjwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWU9XCJmb3VuZFRhZ05hbWVcIj48L3BhcmFtPlxyXG4gIC8vLyA8cmV0dXJucz48L3JldHVybnM+XHJcbiAgcHJpdmF0ZSBpbml0RmllbGRzKGZvdW5kVGFnTmFtZTogc3RyaW5nLCBwYXJzZXI6IFhtbFBhcnNlcik6IGJvb2xlYW4ge1xyXG4gICAgaWYgKGZvdW5kVGFnTmFtZSA9PSBudWxsKVxyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcblxyXG4gICAgaWYgKGZvdW5kVGFnTmFtZSA9PT0gWE1MQ29uc3RhbnRzLk1HX1RBR19GTERIKSB7XHJcbiAgICAgIGxldCBpdGVtOiBGaWVsZERlZiA9IHRoaXMuaW5pdEZpZWxkKHBhcnNlcik7XHJcbiAgICAgIHRoaXMuX2ZpZWxkcy5wdXNoKGl0ZW0pO1xyXG4gICAgfVxyXG4gICAgZWxzZSB7XHJcbiAgICAgIC8vIENsaWVudE1hbmFnZXIuSW5zdGFuY2UuV3JpdGVFcnJvclRvTG9nKFwiaW4gRmllbGRzVGFibGUuaW5pdEZpZWxkcygpIG9ubHkgZmllbGQgdGFnIGFyZSBhbGxvd2VkIHRvIGJlIHBhcnNlZCBhdCB0aGlzIGluc3RhbmNlXCIpO1xyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcbiAgICB9XHJcbiAgICByZXR1cm4gdHJ1ZTtcclxuICB9XHJcblxyXG4gIGluaXRGaWVsZChwYXJzZXI6IFhtbFBhcnNlciwgZGF0YXZpZXc6IEd1aURhdGFWaWV3QmFzZSk6IEZpZWxkRGVmO1xyXG4gIGluaXRGaWVsZChwYXJzZXI6IFhtbFBhcnNlcik6IEZpZWxkRGVmO1xyXG4gIGluaXRGaWVsZChwYXJzZXI6IFhtbFBhcnNlciwgZGF0YXZpZXc/OiBHdWlEYXRhVmlld0Jhc2UpOiBGaWVsZERlZiB7XHJcbiAgICBpZiAoYXJndW1lbnRzLmxlbmd0aCA9PT0gMilcclxuICAgICAgcmV0dXJuIHRoaXMuaW5pdEZpZWxkXzAoZGF0YXZpZXcsIHBhcnNlcik7XHJcbiAgICBlbHNlXHJcbiAgICAgIHJldHVybiB0aGlzLmluaXRGaWVsZF8xKHBhcnNlcik7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vIGNyZWF0ZSBhIGZpZWxkIGFuZCBmaWxsIGl0IGJ5IGRhdGFcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwiZGF0YXZpZXdcIj4gRGF0YXZpZXcgPC9wYXJhbT5cclxuICAvLy8gPHJldHVybnM+IHRoZSBjcmVhdGVkIGZpbGxlZCBmaWVsZCA8L3JldHVybnM+XHJcbiAgcHJpdmF0ZSBpbml0RmllbGRfMChkYXRhdmlldzogR3VpRGF0YVZpZXdCYXNlLCBwYXJzZXI6IFhtbFBhcnNlcik6IEZpZWxkRGVmIHtcclxuICAgIGxldCBmaWVsZDogRmllbGQgPSBuZXcgRmllbGQoPERhdGFWaWV3PmRhdGF2aWV3LCB0aGlzLl9maWVsZHMubGVuZ3RoKTtcclxuICAgIGZpZWxkLmZpbGxEYXRhKHBhcnNlcik7XHJcbiAgICByZXR1cm4gZmllbGQ7XHJcbiAgfVxyXG5cclxuLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyBjcmVhdGUgYSBmaWVsZCBhbmQgZmlsbCBpdCBieSBkYXRhXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHJldHVybnM+IHRoZSBjcmVhdGVkIGZpbGxlZCBmaWVsZCA8L3JldHVybnM+XHJcbiAgcHJpdmF0ZSBpbml0RmllbGRfMShwYXJzZXI6IFhtbFBhcnNlcik6IEZpZWxkRGVmIHtcclxuICAgIGxldCBmaWVsZERlZjogRmllbGREZWYgPSBuZXcgRmllbGREZWYodGhpcy5fZmllbGRzLmxlbmd0aCk7XHJcbiAgICBmaWVsZERlZi5maWxsRGF0YShwYXJzZXIpO1xyXG4gICAgcmV0dXJuIGZpZWxkRGVmO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHJldHVybiB0aGUgbnVtYmVyIG9mIGZpZWxkcyBpbiB0aGUgUmVjb3JkIE1haW5cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGdldFJNU2l6ZSgpOiBudW1iZXIge1xyXG4gICAgaWYgKHRoaXMuX3JtU2l6ZSA9PT0gLTEpXHJcbiAgICAgIHJldHVybiB0aGlzLl9maWVsZHMubGVuZ3RoO1xyXG4gICAgcmV0dXJuIHRoaXMuX3JtU2l6ZTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICB0aGUgaW5kZXggb2YgdGhlIGZpcnN0IGZpZWxkIGluIHRoZSByZWNvcmQgbWFpblxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgZ2V0Uk1JZHgoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9ybUlkeDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBzZXQgUmVjb3JkIE1haW4gc2l6ZVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJybXNcIj50aGUgbmV3IHJlY29yZCBtYWluIHNpemU8L3BhcmFtPlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwiaWR4XCI+dGhlIGluZGV4IG9mIHRoZSBmaXJzdCBmaWVsZCBpbiB0aGUgcmVjb3JkIG1haW48L3BhcmFtPlxyXG4gIHNldFJNUG9zKHJtczogbnVtYmVyLCBpZHg6IG51bWJlcik6IHZvaWQge1xyXG4gICAgaWYgKHJtcyA8IDAgJiYgdGhpcy5fcm1TaXplICE9PSAtMSkge1xyXG4gICAgICBMb2dnZXIuSW5zdGFuY2UuV3JpdGVFeGNlcHRpb25Ub0xvZ1dpdGhNc2coXCJpbiBGaWVsZHNUYWJsZS5zZXRSTVNpemUoKTogaWxsZWdhbCByZWNvcmQgbWFpbiBzaXplOiBcIiArIHJtcyk7XHJcbiAgICB9XHJcbiAgICBlbHNlIGlmICh0aGlzLl9ybVNpemUgPj0gMCkge1xyXG4gICAgICBMb2dnZXIuSW5zdGFuY2UuV3JpdGVFeGNlcHRpb25Ub0xvZ1dpdGhNc2coXCJpbiBGaWVsZHNUYWJsZS5zZXRSTVNpemUoKTogcmVjb3JkIG1haW4gc2l6ZSBhbHJlYWR5IHNldCAhXCIpO1xyXG4gICAgfVxyXG4gICAgZWxzZSB7XHJcbiAgICAgIHRoaXMuX3JtU2l6ZSA9IHJtcztcclxuICAgICAgdGhpcy5fcm1JZHggPSBpZHg7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIGdldCB0aGUgdHlwZSBvZiBmaWVsZCBieSBpdHMgaW5kZXhcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwiaWRcIj50aGUgaWQgb2YgdGhlIGZpZWxkPC9wYXJhbT5cclxuICAvLy8gPHJldHVybnM+IHR5cGUgb2YgdGhlIHJlcXVlc3RlZCBmaWVsZDwvcmV0dXJucz5cclxuICBnZXRUeXBlKGlkOiBudW1iZXIpOiBTdG9yYWdlQXR0cmlidXRlIHtcclxuICAgIHJldHVybiBzdXBlci5nZXRGaWVsZChpZCkuZ2V0VHlwZSgpO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIGludmFsaWRhdGUgc29tZSBvciBhbGwgZmllbGRzIGluIHRoZSB0YWJsZVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJmb3JjZUludmFsaWRhdGVcIj5pZiB0cnVlIHRoZW4gZm9yY2UgdGhlIGludmFsaWRhdGlvbiBvZiBhbGwgdGhlIGZpZWxkczwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lPVwiY2xlYXJGbGFnc1wiPjwvcGFyYW0+XHJcbiAgaW52YWxpZGF0ZShmb3JjZUludmFsaWRhdGU6IGJvb2xlYW4sIGNsZWFyRmxhZ3M6IGJvb2xlYW4pOiB2b2lkIHtcclxuICAgIGZvcihsZXQgaSA9IDAgOyBpIDwgdGhpcy5fZmllbGRzLmxlbmd0aCA7IGkrKylcclxuICAgIHtcclxuICAgICAgbGV0IGN1cnJGaWVsZCA9IHRoaXMuX2ZpZWxkc1tpXTtcclxuICAgICAgKDxGaWVsZD5jdXJyRmllbGQpLmludmFsaWRhdGUoZm9yY2VJbnZhbGlkYXRlLCBjbGVhckZsYWdzKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICB0YWtlIHRoZSB2YWx1ZSBvZiB0aGUgZmllbGRzIGZyb20gdGhlIGN1cnJlbnQgcmVjb3JkXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICB0YWtlVmFsc0Zyb21SZWMoKTogdm9pZCB7XHJcbiAgICBmb3IobGV0IGkgPSAwIDsgaSA8IHRoaXMuX2ZpZWxkcy5sZW5ndGggOyBpKyspIHtcclxuICAgICAgbGV0IGN1cnJGaWVsZCA9IHRoaXMuX2ZpZWxkc1tpXTtcclxuICAgICAgKDxGaWVsZD5jdXJyRmllbGQpLnRha2VWYWxGcm9tUmVjKClcclxuICAgIH1cclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICByZXR1cm4gVFJVRSBpZiB3ZSB3ZW50IHRvIHRoZSBzZXJ2ZXIgZHVyaW5nIGEgZmllbGQncyBjb21wdXRlXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBzZXJ2ZXJSY21wRG9uZSgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9zZXJ2ZXJSY21wRG9uZTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBzZXQgdGhlIHZhbHVlIG9mIHRoZSBcIndlIHdlbnQgdG8gdGhlIHNlcnZlciBmb3IgcmNtcFwiIGluZGljYXRpb25cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwidmFsXCI+bmV3IHZhbHVlPC9wYXJhbT5cclxuICBzZXRTZXJ2ZXJSY21wKHZhbDogYm9vbGVhbik6IHZvaWQge1xyXG4gICAgdGhpcy5fc2VydmVyUmNtcERvbmUgPSB2YWw7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgcmV0dXJuIGEgdmVjdG9yIG9mIGFsbCBmaWVsZHMgaW4gdGhlIHRhYmxlIHRoYXQgYmVsb25ncyB0byBhIGdpdmVuIGxpbmtcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwibG5rSWRcIj50aGUgaWQgb2YgdGhlIGxpbms8L3BhcmFtPlxyXG4gIGdldExpbmtGaWVsZHMobG5rSWQ6IG51bWJlcik6IExpc3Q8RmllbGQ+IHtcclxuICAgIGxldCBsaXN0OiBMaXN0PEZpZWxkPiA9IG5ldyBMaXN0PEZpZWxkPigpO1xyXG5cclxuICAgIHRoaXMuX2ZpZWxkcy5mb3JFYWNoKGZpZWxkID0+IHtcclxuICAgICAgaWYgKCg8RmllbGQ+ZmllbGQpLmdldERhdGF2aWV3SGVhZGVySWQoKSA9PT0gbG5rSWQpIHtcclxuICAgICAgICBsaXN0LnB1c2goPEZpZWxkPmZpZWxkKTtcclxuICAgICAgfVxyXG4gICAgfSk7XHJcbiAgICByZXR1cm4gbGlzdDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy9cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cmV0dXJucz48L3JldHVybnM+XHJcbiAgcmVzZXRSZWNvbXAoKTogdm9pZCB7XHJcbiAgICB0aGlzLl9maWVsZHMuZm9yRWFjaChmaWVsZCA9PiAoPEZpZWxkPmZpZWxkKS5zZXRSZWNvbXB1dGUobnVsbCkpO1xyXG4gIH1cclxufVxyXG5cclxuZXhwb3J0ICB7RmllbGRzVGFibGUgYXMgRmllbGRzVGFibGVFeHQgfVxyXG4iXX0=