import { List, NString } from "@magic-xpa/mscorelib";
import { Logger, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { ConstInterface } from "../ConstInterface";
export class Key {
    constructor(ownerTable) {
        this.Columns = null;
        this._table = null;
        this._id = 0;
        this._table = ownerTable;
        this.Columns = new List();
    }
    FillData(parser) {
        this.FillAttributes(parser);
        while (this.InitInnerObjects(parser, parser.getNextTag())) {
        }
    }
    FillAttributes(parser) {
        let tokensVector;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        let tag;
        let attribute;
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_ATTR_KEY) + ConstInterface.MG_ATTR_KEY.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokensVector.length; j += 2) {
                attribute = (tokensVector.get_Item(j));
                let valueStr = (tokensVector.get_Item(j + 1));
                if (attribute === XMLConstants.MG_ATTR_ID)
                    this._id = XmlParser.getInt(valueStr);
                else if (attribute === XMLConstants.MG_ATTR_TYPE)
                    Logger.Instance.WriteDevToLog("in Key.fillAttributes() obsolete attribute (TODO: remove from server)" + attribute);
                else
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
            }
            parser.setCurrIndex(++endContext);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in Key.fillAttributes() out of string bounds");
    }
    InitElements(tokensVector) {
        for (let j = 0; j < tokensVector.length; j = j + 2) {
            let attribute = tokensVector.get_Item(j);
            let valueStr = tokensVector.get_Item(j + 1);
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID:
                    this.Columns.push(this._table.FldsTab.getField(XmlParser.getInt(valueStr)));
                    break;
                case XMLConstants.MG_ATTR_SIZE:
                    break;
                case ConstInterface.MG_ATTR_DIR:
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                    break;
            }
        }
    }
    InitInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_COLUMN) {
            let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
            if (endContext !== -1 && endContext < parser.getXMLdata().length) {
                let tag = parser.getXMLsubstring(endContext);
                parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_COLUMN) + ConstInterface.MG_TAG_COLUMN.length);
                let tokens = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
                this.InitElements(tokens);
                parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
            }
            else
                Logger.Instance.WriteExceptionToLogWithMsg("in Key.initInnerObjects() out of string bounds");
        }
        else if (foundTagName === '/' + ConstInterface.MG_ATTR_KEY) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in LinksTable.initInnerObjects(): " + foundTagName);
            return false;
        }
        return true;
    }
    GetKeyId() {
        return this._id;
    }
}
//# sourceMappingURL=data:application/json;base64,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